/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.costexplorer;

import javax.annotation.Generated;

import com.amazonaws.services.costexplorer.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSCostExplorer}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSCostExplorer implements AWSCostExplorer {

    protected AbstractAWSCostExplorer() {
    }

    @Override
    public CreateAnomalyMonitorResult createAnomalyMonitor(CreateAnomalyMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAnomalySubscriptionResult createAnomalySubscription(CreateAnomalySubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCostCategoryDefinitionResult createCostCategoryDefinition(CreateCostCategoryDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAnomalyMonitorResult deleteAnomalyMonitor(DeleteAnomalyMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAnomalySubscriptionResult deleteAnomalySubscription(DeleteAnomalySubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCostCategoryDefinitionResult deleteCostCategoryDefinition(DeleteCostCategoryDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCostCategoryDefinitionResult describeCostCategoryDefinition(DescribeCostCategoryDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAnomaliesResult getAnomalies(GetAnomaliesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAnomalyMonitorsResult getAnomalyMonitors(GetAnomalyMonitorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAnomalySubscriptionsResult getAnomalySubscriptions(GetAnomalySubscriptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCostAndUsageResult getCostAndUsage(GetCostAndUsageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCostAndUsageWithResourcesResult getCostAndUsageWithResources(GetCostAndUsageWithResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCostCategoriesResult getCostCategories(GetCostCategoriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCostForecastResult getCostForecast(GetCostForecastRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDimensionValuesResult getDimensionValues(GetDimensionValuesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReservationCoverageResult getReservationCoverage(GetReservationCoverageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReservationPurchaseRecommendationResult getReservationPurchaseRecommendation(GetReservationPurchaseRecommendationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReservationUtilizationResult getReservationUtilization(GetReservationUtilizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRightsizingRecommendationResult getRightsizingRecommendation(GetRightsizingRecommendationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSavingsPlansCoverageResult getSavingsPlansCoverage(GetSavingsPlansCoverageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSavingsPlansPurchaseRecommendationResult getSavingsPlansPurchaseRecommendation(GetSavingsPlansPurchaseRecommendationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSavingsPlansUtilizationResult getSavingsPlansUtilization(GetSavingsPlansUtilizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSavingsPlansUtilizationDetailsResult getSavingsPlansUtilizationDetails(GetSavingsPlansUtilizationDetailsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTagsResult getTags(GetTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUsageForecastResult getUsageForecast(GetUsageForecastRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCostAllocationTagsResult listCostAllocationTags(ListCostAllocationTagsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCostCategoryDefinitionsResult listCostCategoryDefinitions(ListCostCategoryDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSavingsPlansPurchaseRecommendationGenerationResult listSavingsPlansPurchaseRecommendationGeneration(
            ListSavingsPlansPurchaseRecommendationGenerationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ProvideAnomalyFeedbackResult provideAnomalyFeedback(ProvideAnomalyFeedbackRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartSavingsPlansPurchaseRecommendationGenerationResult startSavingsPlansPurchaseRecommendationGeneration(
            StartSavingsPlansPurchaseRecommendationGenerationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAnomalyMonitorResult updateAnomalyMonitor(UpdateAnomalyMonitorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAnomalySubscriptionResult updateAnomalySubscription(UpdateAnomalySubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCostAllocationTagsStatusResult updateCostAllocationTagsStatus(UpdateCostAllocationTagsStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCostCategoryDefinitionResult updateCostCategoryDefinition(UpdateCostCategoryDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
