/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.costexplorer.AWSCostExplorerAsync;
import com.amazonaws.services.costexplorer.AWSCostExplorerAsyncClientBuilder;
import com.amazonaws.services.costexplorer.AWSCostExplorerClient;
import com.amazonaws.services.costexplorer.model.GetCostAndUsageRequest;
import com.amazonaws.services.costexplorer.model.GetCostAndUsageResult;
import com.amazonaws.services.costexplorer.model.GetCostForecastRequest;
import com.amazonaws.services.costexplorer.model.GetCostForecastResult;
import com.amazonaws.services.costexplorer.model.GetDimensionValuesRequest;
import com.amazonaws.services.costexplorer.model.GetDimensionValuesResult;
import com.amazonaws.services.costexplorer.model.GetReservationCoverageRequest;
import com.amazonaws.services.costexplorer.model.GetReservationCoverageResult;
import com.amazonaws.services.costexplorer.model.GetReservationPurchaseRecommendationRequest;
import com.amazonaws.services.costexplorer.model.GetReservationPurchaseRecommendationResult;
import com.amazonaws.services.costexplorer.model.GetReservationUtilizationRequest;
import com.amazonaws.services.costexplorer.model.GetReservationUtilizationResult;
import com.amazonaws.services.costexplorer.model.GetRightsizingRecommendationRequest;
import com.amazonaws.services.costexplorer.model.GetRightsizingRecommendationResult;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansCoverageRequest;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansCoverageResult;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResult;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResult;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansUtilizationRequest;
import com.amazonaws.services.costexplorer.model.GetSavingsPlansUtilizationResult;
import com.amazonaws.services.costexplorer.model.GetTagsRequest;
import com.amazonaws.services.costexplorer.model.GetTagsResult;
import com.amazonaws.services.costexplorer.model.GetUsageForecastRequest;
import com.amazonaws.services.costexplorer.model.GetUsageForecastResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCostExplorerAsyncClient
extends AWSCostExplorerClient
implements AWSCostExplorerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSCostExplorerAsyncClientBuilder asyncBuilder() {
        return AWSCostExplorerAsyncClientBuilder.standard();
    }

    AWSCostExplorerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetCostAndUsageResult> getCostAndUsageAsync(GetCostAndUsageRequest request) {
        return this.getCostAndUsageAsync(request, null);
    }

    @Override
    public Future<GetCostAndUsageResult> getCostAndUsageAsync(GetCostAndUsageRequest request, final AsyncHandler<GetCostAndUsageRequest, GetCostAndUsageResult> asyncHandler) {
        final GetCostAndUsageRequest finalRequest = (GetCostAndUsageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCostAndUsageResult>(){

            @Override
            public GetCostAndUsageResult call() throws Exception {
                GetCostAndUsageResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetCostAndUsage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCostForecastResult> getCostForecastAsync(GetCostForecastRequest request) {
        return this.getCostForecastAsync(request, null);
    }

    @Override
    public Future<GetCostForecastResult> getCostForecastAsync(GetCostForecastRequest request, final AsyncHandler<GetCostForecastRequest, GetCostForecastResult> asyncHandler) {
        final GetCostForecastRequest finalRequest = (GetCostForecastRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCostForecastResult>(){

            @Override
            public GetCostForecastResult call() throws Exception {
                GetCostForecastResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetCostForecast(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDimensionValuesResult> getDimensionValuesAsync(GetDimensionValuesRequest request) {
        return this.getDimensionValuesAsync(request, null);
    }

    @Override
    public Future<GetDimensionValuesResult> getDimensionValuesAsync(GetDimensionValuesRequest request, final AsyncHandler<GetDimensionValuesRequest, GetDimensionValuesResult> asyncHandler) {
        final GetDimensionValuesRequest finalRequest = (GetDimensionValuesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDimensionValuesResult>(){

            @Override
            public GetDimensionValuesResult call() throws Exception {
                GetDimensionValuesResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetDimensionValues(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReservationCoverageResult> getReservationCoverageAsync(GetReservationCoverageRequest request) {
        return this.getReservationCoverageAsync(request, null);
    }

    @Override
    public Future<GetReservationCoverageResult> getReservationCoverageAsync(GetReservationCoverageRequest request, final AsyncHandler<GetReservationCoverageRequest, GetReservationCoverageResult> asyncHandler) {
        final GetReservationCoverageRequest finalRequest = (GetReservationCoverageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReservationCoverageResult>(){

            @Override
            public GetReservationCoverageResult call() throws Exception {
                GetReservationCoverageResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetReservationCoverage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReservationPurchaseRecommendationResult> getReservationPurchaseRecommendationAsync(GetReservationPurchaseRecommendationRequest request) {
        return this.getReservationPurchaseRecommendationAsync(request, null);
    }

    @Override
    public Future<GetReservationPurchaseRecommendationResult> getReservationPurchaseRecommendationAsync(GetReservationPurchaseRecommendationRequest request, final AsyncHandler<GetReservationPurchaseRecommendationRequest, GetReservationPurchaseRecommendationResult> asyncHandler) {
        final GetReservationPurchaseRecommendationRequest finalRequest = (GetReservationPurchaseRecommendationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReservationPurchaseRecommendationResult>(){

            @Override
            public GetReservationPurchaseRecommendationResult call() throws Exception {
                GetReservationPurchaseRecommendationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetReservationPurchaseRecommendation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReservationUtilizationResult> getReservationUtilizationAsync(GetReservationUtilizationRequest request) {
        return this.getReservationUtilizationAsync(request, null);
    }

    @Override
    public Future<GetReservationUtilizationResult> getReservationUtilizationAsync(GetReservationUtilizationRequest request, final AsyncHandler<GetReservationUtilizationRequest, GetReservationUtilizationResult> asyncHandler) {
        final GetReservationUtilizationRequest finalRequest = (GetReservationUtilizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReservationUtilizationResult>(){

            @Override
            public GetReservationUtilizationResult call() throws Exception {
                GetReservationUtilizationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetReservationUtilization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRightsizingRecommendationResult> getRightsizingRecommendationAsync(GetRightsizingRecommendationRequest request) {
        return this.getRightsizingRecommendationAsync(request, null);
    }

    @Override
    public Future<GetRightsizingRecommendationResult> getRightsizingRecommendationAsync(GetRightsizingRecommendationRequest request, final AsyncHandler<GetRightsizingRecommendationRequest, GetRightsizingRecommendationResult> asyncHandler) {
        final GetRightsizingRecommendationRequest finalRequest = (GetRightsizingRecommendationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRightsizingRecommendationResult>(){

            @Override
            public GetRightsizingRecommendationResult call() throws Exception {
                GetRightsizingRecommendationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetRightsizingRecommendation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSavingsPlansCoverageResult> getSavingsPlansCoverageAsync(GetSavingsPlansCoverageRequest request) {
        return this.getSavingsPlansCoverageAsync(request, null);
    }

    @Override
    public Future<GetSavingsPlansCoverageResult> getSavingsPlansCoverageAsync(GetSavingsPlansCoverageRequest request, final AsyncHandler<GetSavingsPlansCoverageRequest, GetSavingsPlansCoverageResult> asyncHandler) {
        final GetSavingsPlansCoverageRequest finalRequest = (GetSavingsPlansCoverageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSavingsPlansCoverageResult>(){

            @Override
            public GetSavingsPlansCoverageResult call() throws Exception {
                GetSavingsPlansCoverageResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetSavingsPlansCoverage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSavingsPlansPurchaseRecommendationResult> getSavingsPlansPurchaseRecommendationAsync(GetSavingsPlansPurchaseRecommendationRequest request) {
        return this.getSavingsPlansPurchaseRecommendationAsync(request, null);
    }

    @Override
    public Future<GetSavingsPlansPurchaseRecommendationResult> getSavingsPlansPurchaseRecommendationAsync(GetSavingsPlansPurchaseRecommendationRequest request, final AsyncHandler<GetSavingsPlansPurchaseRecommendationRequest, GetSavingsPlansPurchaseRecommendationResult> asyncHandler) {
        final GetSavingsPlansPurchaseRecommendationRequest finalRequest = (GetSavingsPlansPurchaseRecommendationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSavingsPlansPurchaseRecommendationResult>(){

            @Override
            public GetSavingsPlansPurchaseRecommendationResult call() throws Exception {
                GetSavingsPlansPurchaseRecommendationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetSavingsPlansPurchaseRecommendation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSavingsPlansUtilizationResult> getSavingsPlansUtilizationAsync(GetSavingsPlansUtilizationRequest request) {
        return this.getSavingsPlansUtilizationAsync(request, null);
    }

    @Override
    public Future<GetSavingsPlansUtilizationResult> getSavingsPlansUtilizationAsync(GetSavingsPlansUtilizationRequest request, final AsyncHandler<GetSavingsPlansUtilizationRequest, GetSavingsPlansUtilizationResult> asyncHandler) {
        final GetSavingsPlansUtilizationRequest finalRequest = (GetSavingsPlansUtilizationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSavingsPlansUtilizationResult>(){

            @Override
            public GetSavingsPlansUtilizationResult call() throws Exception {
                GetSavingsPlansUtilizationResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetSavingsPlansUtilization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSavingsPlansUtilizationDetailsResult> getSavingsPlansUtilizationDetailsAsync(GetSavingsPlansUtilizationDetailsRequest request) {
        return this.getSavingsPlansUtilizationDetailsAsync(request, null);
    }

    @Override
    public Future<GetSavingsPlansUtilizationDetailsResult> getSavingsPlansUtilizationDetailsAsync(GetSavingsPlansUtilizationDetailsRequest request, final AsyncHandler<GetSavingsPlansUtilizationDetailsRequest, GetSavingsPlansUtilizationDetailsResult> asyncHandler) {
        final GetSavingsPlansUtilizationDetailsRequest finalRequest = (GetSavingsPlansUtilizationDetailsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSavingsPlansUtilizationDetailsResult>(){

            @Override
            public GetSavingsPlansUtilizationDetailsResult call() throws Exception {
                GetSavingsPlansUtilizationDetailsResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetSavingsPlansUtilizationDetails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTagsResult> getTagsAsync(GetTagsRequest request) {
        return this.getTagsAsync(request, null);
    }

    @Override
    public Future<GetTagsResult> getTagsAsync(GetTagsRequest request, final AsyncHandler<GetTagsRequest, GetTagsResult> asyncHandler) {
        final GetTagsRequest finalRequest = (GetTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTagsResult>(){

            @Override
            public GetTagsResult call() throws Exception {
                GetTagsResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUsageForecastResult> getUsageForecastAsync(GetUsageForecastRequest request) {
        return this.getUsageForecastAsync(request, null);
    }

    @Override
    public Future<GetUsageForecastResult> getUsageForecastAsync(GetUsageForecastRequest request, final AsyncHandler<GetUsageForecastRequest, GetUsageForecastResult> asyncHandler) {
        final GetUsageForecastRequest finalRequest = (GetUsageForecastRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetUsageForecastResult>(){

            @Override
            public GetUsageForecastResult call() throws Exception {
                GetUsageForecastResult result = null;
                try {
                    result = AWSCostExplorerAsyncClient.this.executeGetUsageForecast(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

