/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.AmazonClientException;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.DateUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Date;

public class SdkJsonGenerator {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final JsonFactory FACTORY = new JsonFactory();
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
    private final JsonGenerator generator;

    public SdkJsonGenerator() {
        try {
            this.generator = FACTORY.createGenerator((OutputStream)this.baos);
        }
        catch (IOException e) {
            throw new JsonGenerationException(e);
        }
    }

    public SdkJsonGenerator writeStartArray() {
        try {
            this.generator.writeStartArray();
        }
        catch (IOException e) {
            throw new JsonGenerationException(e);
        }
        return this;
    }

    public SdkJsonGenerator writeEndArray() {
        try {
            this.generator.writeEndArray();
        }
        catch (IOException e) {
            throw new JsonGenerationException(e);
        }
        return this;
    }

    public SdkJsonGenerator writeStartObject() {
        try {
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw new JsonGenerationException(e);
        }
        return this;
    }

    public SdkJsonGenerator writeEndObject() {
        try {
            this.generator.writeEndObject();
        }
        catch (IOException e) {
            throw new JsonGenerationException(e);
        }
        return this;
    }

    public SdkJsonGenerator writeFieldName(String fieldName) {
        try {
            this.generator.writeFieldName(fieldName);
        }
        catch (IOException e) {
            throw new JsonGenerationException(e);
        }
        return this;
    }

    public SdkJsonGenerator writeValue(String val) {
        try {
            this.generator.writeString(val);
        }
        catch (IOException e) {
            throw new JsonGenerationException(e);
        }
        return this;
    }

    public SdkJsonGenerator writeValue(boolean bool) {
        try {
            this.generator.writeBoolean(bool);
        }
        catch (IOException e) {
            throw new JsonGenerationException(e);
        }
        return this;
    }

    public SdkJsonGenerator writeValue(long val) {
        try {
            this.generator.writeNumber(val);
        }
        catch (IOException e) {
            throw new JsonGenerationException(e);
        }
        return this;
    }

    public SdkJsonGenerator writeValue(double val) {
        try {
            this.generator.writeNumber(val);
        }
        catch (IOException e) {
            throw new JsonGenerationException(e);
        }
        return this;
    }

    public SdkJsonGenerator writeValue(ByteBuffer bytes) {
        try {
            this.generator.writeBinary(BinaryUtils.copyBytesFrom(bytes));
        }
        catch (IOException e) {
            throw new JsonGenerationException(e);
        }
        return this;
    }

    public SdkJsonGenerator writeValue(Date date) {
        try {
            this.generator.writeNumber(DateUtils.formatServiceSpecificDate(date));
        }
        catch (IOException e) {
            throw new JsonGenerationException(e);
        }
        return this;
    }

    private void close() {
        try {
            this.generator.close();
        }
        catch (IOException e) {
            throw new JsonGenerationException(e);
        }
    }

    public byte[] getBytes() {
        this.close();
        return this.baos.toByteArray();
    }

    public static class JsonGenerationException
    extends AmazonClientException {
        public JsonGenerationException(Throwable t) {
            super(t);
        }
    }
}

