/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Connect is an easy-to-use omnichannel cloud contact center service that enables companies of any size to
 * deliver superior customer service at a lower cost. Amazon Connect communications capabilities make it easy for
 * companies to deliver personalized interactions across communication channels, including chat.
 * </p>
 * <p>
 * Use the Amazon Connect Participant Service to manage participants (for example, agents, customers, and managers
 * listening in), and to send messages and events within a chat contact. The APIs in the service enable the following:
 * sending chat messages, attachment sharing, managing a participant's connection state and message events, and
 * retrieving chat transcripts.
 * </p>
 */
package com.amazonaws.services.connectparticipant;

