/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectcontactlens;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.connectcontactlens.AmazonConnectContactLensAsync;
import com.amazonaws.services.connectcontactlens.AmazonConnectContactLensAsyncClientBuilder;
import com.amazonaws.services.connectcontactlens.AmazonConnectContactLensClient;
import com.amazonaws.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest;
import com.amazonaws.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonConnectContactLensAsyncClient
extends AmazonConnectContactLensClient
implements AmazonConnectContactLensAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonConnectContactLensAsyncClientBuilder asyncBuilder() {
        return AmazonConnectContactLensAsyncClientBuilder.standard();
    }

    AmazonConnectContactLensAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonConnectContactLensAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ListRealtimeContactAnalysisSegmentsResult> listRealtimeContactAnalysisSegmentsAsync(ListRealtimeContactAnalysisSegmentsRequest request) {
        return this.listRealtimeContactAnalysisSegmentsAsync(request, null);
    }

    @Override
    public Future<ListRealtimeContactAnalysisSegmentsResult> listRealtimeContactAnalysisSegmentsAsync(ListRealtimeContactAnalysisSegmentsRequest request, final AsyncHandler<ListRealtimeContactAnalysisSegmentsRequest, ListRealtimeContactAnalysisSegmentsResult> asyncHandler) {
        final ListRealtimeContactAnalysisSegmentsRequest finalRequest = (ListRealtimeContactAnalysisSegmentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRealtimeContactAnalysisSegmentsResult>(){

            @Override
            public ListRealtimeContactAnalysisSegmentsResult call() throws Exception {
                ListRealtimeContactAnalysisSegmentsResult result = null;
                try {
                    result = AmazonConnectContactLensAsyncClient.this.executeListRealtimeContactAnalysisSegments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

