/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.transform.FilterV2Marshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilterV2
implements Serializable,
Cloneable,
StructuredPojo {
    private String filterKey;
    private List<String> filterValues;

    public void setFilterKey(String filterKey) {
        this.filterKey = filterKey;
    }

    public String getFilterKey() {
        return this.filterKey;
    }

    public FilterV2 withFilterKey(String filterKey) {
        this.setFilterKey(filterKey);
        return this;
    }

    public List<String> getFilterValues() {
        return this.filterValues;
    }

    public void setFilterValues(Collection<String> filterValues) {
        if (filterValues == null) {
            this.filterValues = null;
            return;
        }
        this.filterValues = new ArrayList<String>(filterValues);
    }

    public FilterV2 withFilterValues(String ... filterValues) {
        if (this.filterValues == null) {
            this.setFilterValues(new ArrayList<String>(filterValues.length));
        }
        for (String ele : filterValues) {
            this.filterValues.add(ele);
        }
        return this;
    }

    public FilterV2 withFilterValues(Collection<String> filterValues) {
        this.setFilterValues(filterValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilterKey() != null) {
            sb.append("FilterKey: ").append(this.getFilterKey()).append(",");
        }
        if (this.getFilterValues() != null) {
            sb.append("FilterValues: ").append(this.getFilterValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterV2)) {
            return false;
        }
        FilterV2 other = (FilterV2)obj;
        if (other.getFilterKey() == null ^ this.getFilterKey() == null) {
            return false;
        }
        if (other.getFilterKey() != null && !other.getFilterKey().equals(this.getFilterKey())) {
            return false;
        }
        if (other.getFilterValues() == null ^ this.getFilterValues() == null) {
            return false;
        }
        return other.getFilterValues() == null || other.getFilterValues().equals(this.getFilterValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilterKey() == null ? 0 : this.getFilterKey().hashCode());
        hashCode = 31 * hashCode + (this.getFilterValues() == null ? 0 : this.getFilterValues().hashCode());
        return hashCode;
    }

    public FilterV2 clone() {
        try {
            return (FilterV2)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilterV2Marshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

