/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.connect.model.MetricInterval;
import java.util.Date;

@SdkInternalApi
public class MetricIntervalMarshaller {
    private static final MarshallingInfo<String> INTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Interval").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("unixTimestamp").build();
    private static final MetricIntervalMarshaller instance = new MetricIntervalMarshaller();

    public static MetricIntervalMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricInterval metricInterval, ProtocolMarshaller protocolMarshaller) {
        if (metricInterval == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metricInterval.getInterval(), INTERVAL_BINDING);
            protocolMarshaller.marshall((Object)metricInterval.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)metricInterval.getEndTime(), ENDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

