/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains details about why a contact was disconnected. Only Amazon Connect outbound campaigns can provide this field.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisconnectReason" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DisconnectReason implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * A code that indicates how the contact was terminated.
     * </p>
     */
    private String code;

    /**
     * <p>
     * A code that indicates how the contact was terminated.
     * </p>
     * 
     * @param code
     *        A code that indicates how the contact was terminated.
     */

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * <p>
     * A code that indicates how the contact was terminated.
     * </p>
     * 
     * @return A code that indicates how the contact was terminated.
     */

    public String getCode() {
        return this.code;
    }

    /**
     * <p>
     * A code that indicates how the contact was terminated.
     * </p>
     * 
     * @param code
     *        A code that indicates how the contact was terminated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DisconnectReason withCode(String code) {
        setCode(code);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCode() != null)
            sb.append("Code: ").append(getCode());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DisconnectReason == false)
            return false;
        DisconnectReason other = (DisconnectReason) obj;
        if (other.getCode() == null ^ this.getCode() == null)
            return false;
        if (other.getCode() != null && other.getCode().equals(this.getCode()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCode() == null) ? 0 : getCode().hashCode());
        return hashCode;
    }

    @Override
    public DisconnectReason clone() {
        try {
            return (DisconnectReason) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.connect.model.transform.DisconnectReasonMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
