/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The search criteria to be used to search tags.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ResourceTagsSearchCriteria" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ResourceTagsSearchCriteria implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The search criteria to be used to return tags.
     * </p>
     */
    private TagSearchCondition tagSearchCondition;

    /**
     * <p>
     * The search criteria to be used to return tags.
     * </p>
     * 
     * @param tagSearchCondition
     *        The search criteria to be used to return tags.
     */

    public void setTagSearchCondition(TagSearchCondition tagSearchCondition) {
        this.tagSearchCondition = tagSearchCondition;
    }

    /**
     * <p>
     * The search criteria to be used to return tags.
     * </p>
     * 
     * @return The search criteria to be used to return tags.
     */

    public TagSearchCondition getTagSearchCondition() {
        return this.tagSearchCondition;
    }

    /**
     * <p>
     * The search criteria to be used to return tags.
     * </p>
     * 
     * @param tagSearchCondition
     *        The search criteria to be used to return tags.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceTagsSearchCriteria withTagSearchCondition(TagSearchCondition tagSearchCondition) {
        setTagSearchCondition(tagSearchCondition);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTagSearchCondition() != null)
            sb.append("TagSearchCondition: ").append(getTagSearchCondition());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ResourceTagsSearchCriteria == false)
            return false;
        ResourceTagsSearchCriteria other = (ResourceTagsSearchCriteria) obj;
        if (other.getTagSearchCondition() == null ^ this.getTagSearchCondition() == null)
            return false;
        if (other.getTagSearchCondition() != null && other.getTagSearchCondition().equals(this.getTagSearchCondition()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTagSearchCondition() == null) ? 0 : getTagSearchCondition().hashCode());
        return hashCode;
    }

    @Override
    public ResourceTagsSearchCriteria clone() {
        try {
            return (ResourceTagsSearchCriteria) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.connect.model.transform.ResourceTagsSearchCriteriaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
