/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import javax.annotation.Generated;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum InstanceStorageResourceType {

    CHAT_TRANSCRIPTS("CHAT_TRANSCRIPTS"),
    CALL_RECORDINGS("CALL_RECORDINGS"),
    SCHEDULED_REPORTS("SCHEDULED_REPORTS"),
    MEDIA_STREAMS("MEDIA_STREAMS"),
    CONTACT_TRACE_RECORDS("CONTACT_TRACE_RECORDS"),
    AGENT_EVENTS("AGENT_EVENTS"),
    REAL_TIME_CONTACT_ANALYSIS_SEGMENTS("REAL_TIME_CONTACT_ANALYSIS_SEGMENTS"),
    ATTACHMENTS("ATTACHMENTS"),
    CONTACT_EVALUATIONS("CONTACT_EVALUATIONS"),
    SCREEN_RECORDINGS("SCREEN_RECORDINGS");

    private String value;

    private InstanceStorageResourceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return InstanceStorageResourceType corresponding to the value
     *
     * @throws IllegalArgumentException
     *         If the specified value does not map to one of the known values in this enum.
     */
    public static InstanceStorageResourceType fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (InstanceStorageResourceType enumEntry : InstanceStorageResourceType.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}
