/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about scoring strategy for an evaluation form.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/EvaluationFormScoringStrategy"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class EvaluationFormScoringStrategy implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The scoring mode of the evaluation form.
     * </p>
     */
    private String mode;
    /**
     * <p>
     * The scoring status of the evaluation form.
     * </p>
     */
    private String status;

    /**
     * <p>
     * The scoring mode of the evaluation form.
     * </p>
     * 
     * @param mode
     *        The scoring mode of the evaluation form.
     * @see EvaluationFormScoringMode
     */

    public void setMode(String mode) {
        this.mode = mode;
    }

    /**
     * <p>
     * The scoring mode of the evaluation form.
     * </p>
     * 
     * @return The scoring mode of the evaluation form.
     * @see EvaluationFormScoringMode
     */

    public String getMode() {
        return this.mode;
    }

    /**
     * <p>
     * The scoring mode of the evaluation form.
     * </p>
     * 
     * @param mode
     *        The scoring mode of the evaluation form.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EvaluationFormScoringMode
     */

    public EvaluationFormScoringStrategy withMode(String mode) {
        setMode(mode);
        return this;
    }

    /**
     * <p>
     * The scoring mode of the evaluation form.
     * </p>
     * 
     * @param mode
     *        The scoring mode of the evaluation form.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EvaluationFormScoringMode
     */

    public EvaluationFormScoringStrategy withMode(EvaluationFormScoringMode mode) {
        this.mode = mode.toString();
        return this;
    }

    /**
     * <p>
     * The scoring status of the evaluation form.
     * </p>
     * 
     * @param status
     *        The scoring status of the evaluation form.
     * @see EvaluationFormScoringStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The scoring status of the evaluation form.
     * </p>
     * 
     * @return The scoring status of the evaluation form.
     * @see EvaluationFormScoringStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The scoring status of the evaluation form.
     * </p>
     * 
     * @param status
     *        The scoring status of the evaluation form.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EvaluationFormScoringStatus
     */

    public EvaluationFormScoringStrategy withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The scoring status of the evaluation form.
     * </p>
     * 
     * @param status
     *        The scoring status of the evaluation form.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EvaluationFormScoringStatus
     */

    public EvaluationFormScoringStrategy withStatus(EvaluationFormScoringStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMode() != null)
            sb.append("Mode: ").append(getMode()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof EvaluationFormScoringStrategy == false)
            return false;
        EvaluationFormScoringStrategy other = (EvaluationFormScoringStrategy) obj;
        if (other.getMode() == null ^ this.getMode() == null)
            return false;
        if (other.getMode() != null && other.getMode().equals(this.getMode()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMode() == null) ? 0 : getMode().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        return hashCode;
    }

    @Override
    public EvaluationFormScoringStrategy clone() {
        try {
            return (EvaluationFormScoringStrategy) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.connect.model.transform.EvaluationFormScoringStrategyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
