/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.connect.AmazonConnectAsync;
import com.amazonaws.services.connect.AmazonConnectAsyncClientBuilder;
import com.amazonaws.services.connect.AmazonConnectClient;
import com.amazonaws.services.connect.model.CreateUserRequest;
import com.amazonaws.services.connect.model.CreateUserResult;
import com.amazonaws.services.connect.model.DeleteUserRequest;
import com.amazonaws.services.connect.model.DeleteUserResult;
import com.amazonaws.services.connect.model.DescribeUserHierarchyGroupRequest;
import com.amazonaws.services.connect.model.DescribeUserHierarchyGroupResult;
import com.amazonaws.services.connect.model.DescribeUserHierarchyStructureRequest;
import com.amazonaws.services.connect.model.DescribeUserHierarchyStructureResult;
import com.amazonaws.services.connect.model.DescribeUserRequest;
import com.amazonaws.services.connect.model.DescribeUserResult;
import com.amazonaws.services.connect.model.GetContactAttributesRequest;
import com.amazonaws.services.connect.model.GetContactAttributesResult;
import com.amazonaws.services.connect.model.GetCurrentMetricDataRequest;
import com.amazonaws.services.connect.model.GetCurrentMetricDataResult;
import com.amazonaws.services.connect.model.GetFederationTokenRequest;
import com.amazonaws.services.connect.model.GetFederationTokenResult;
import com.amazonaws.services.connect.model.GetMetricDataRequest;
import com.amazonaws.services.connect.model.GetMetricDataResult;
import com.amazonaws.services.connect.model.ListContactFlowsRequest;
import com.amazonaws.services.connect.model.ListContactFlowsResult;
import com.amazonaws.services.connect.model.ListHoursOfOperationsRequest;
import com.amazonaws.services.connect.model.ListHoursOfOperationsResult;
import com.amazonaws.services.connect.model.ListPhoneNumbersRequest;
import com.amazonaws.services.connect.model.ListPhoneNumbersResult;
import com.amazonaws.services.connect.model.ListQueuesRequest;
import com.amazonaws.services.connect.model.ListQueuesResult;
import com.amazonaws.services.connect.model.ListRoutingProfilesRequest;
import com.amazonaws.services.connect.model.ListRoutingProfilesResult;
import com.amazonaws.services.connect.model.ListSecurityProfilesRequest;
import com.amazonaws.services.connect.model.ListSecurityProfilesResult;
import com.amazonaws.services.connect.model.ListTagsForResourceRequest;
import com.amazonaws.services.connect.model.ListTagsForResourceResult;
import com.amazonaws.services.connect.model.ListUserHierarchyGroupsRequest;
import com.amazonaws.services.connect.model.ListUserHierarchyGroupsResult;
import com.amazonaws.services.connect.model.ListUsersRequest;
import com.amazonaws.services.connect.model.ListUsersResult;
import com.amazonaws.services.connect.model.ResumeContactRecordingRequest;
import com.amazonaws.services.connect.model.ResumeContactRecordingResult;
import com.amazonaws.services.connect.model.StartChatContactRequest;
import com.amazonaws.services.connect.model.StartChatContactResult;
import com.amazonaws.services.connect.model.StartContactRecordingRequest;
import com.amazonaws.services.connect.model.StartContactRecordingResult;
import com.amazonaws.services.connect.model.StartOutboundVoiceContactRequest;
import com.amazonaws.services.connect.model.StartOutboundVoiceContactResult;
import com.amazonaws.services.connect.model.StopContactRecordingRequest;
import com.amazonaws.services.connect.model.StopContactRecordingResult;
import com.amazonaws.services.connect.model.StopContactRequest;
import com.amazonaws.services.connect.model.StopContactResult;
import com.amazonaws.services.connect.model.SuspendContactRecordingRequest;
import com.amazonaws.services.connect.model.SuspendContactRecordingResult;
import com.amazonaws.services.connect.model.TagResourceRequest;
import com.amazonaws.services.connect.model.TagResourceResult;
import com.amazonaws.services.connect.model.UntagResourceRequest;
import com.amazonaws.services.connect.model.UntagResourceResult;
import com.amazonaws.services.connect.model.UpdateContactAttributesRequest;
import com.amazonaws.services.connect.model.UpdateContactAttributesResult;
import com.amazonaws.services.connect.model.UpdateUserHierarchyRequest;
import com.amazonaws.services.connect.model.UpdateUserHierarchyResult;
import com.amazonaws.services.connect.model.UpdateUserIdentityInfoRequest;
import com.amazonaws.services.connect.model.UpdateUserIdentityInfoResult;
import com.amazonaws.services.connect.model.UpdateUserPhoneConfigRequest;
import com.amazonaws.services.connect.model.UpdateUserPhoneConfigResult;
import com.amazonaws.services.connect.model.UpdateUserRoutingProfileRequest;
import com.amazonaws.services.connect.model.UpdateUserRoutingProfileResult;
import com.amazonaws.services.connect.model.UpdateUserSecurityProfilesRequest;
import com.amazonaws.services.connect.model.UpdateUserSecurityProfilesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonConnectAsyncClient
extends AmazonConnectClient
implements AmazonConnectAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonConnectAsyncClientBuilder asyncBuilder() {
        return AmazonConnectAsyncClientBuilder.standard();
    }

    AmazonConnectAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonConnectAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request) {
        return this.createUserAsync(request, null);
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request, final AsyncHandler<CreateUserRequest, CreateUserResult> asyncHandler) {
        final CreateUserRequest finalRequest = (CreateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateUserResult>(){

            @Override
            public CreateUserResult call() throws Exception {
                CreateUserResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeCreateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request) {
        return this.deleteUserAsync(request, null);
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request, final AsyncHandler<DeleteUserRequest, DeleteUserResult> asyncHandler) {
        final DeleteUserRequest finalRequest = (DeleteUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteUserResult>(){

            @Override
            public DeleteUserResult call() throws Exception {
                DeleteUserResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeDeleteUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserResult> describeUserAsync(DescribeUserRequest request) {
        return this.describeUserAsync(request, null);
    }

    @Override
    public Future<DescribeUserResult> describeUserAsync(DescribeUserRequest request, final AsyncHandler<DescribeUserRequest, DescribeUserResult> asyncHandler) {
        final DescribeUserRequest finalRequest = (DescribeUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeUserResult>(){

            @Override
            public DescribeUserResult call() throws Exception {
                DescribeUserResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeDescribeUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserHierarchyGroupResult> describeUserHierarchyGroupAsync(DescribeUserHierarchyGroupRequest request) {
        return this.describeUserHierarchyGroupAsync(request, null);
    }

    @Override
    public Future<DescribeUserHierarchyGroupResult> describeUserHierarchyGroupAsync(DescribeUserHierarchyGroupRequest request, final AsyncHandler<DescribeUserHierarchyGroupRequest, DescribeUserHierarchyGroupResult> asyncHandler) {
        final DescribeUserHierarchyGroupRequest finalRequest = (DescribeUserHierarchyGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeUserHierarchyGroupResult>(){

            @Override
            public DescribeUserHierarchyGroupResult call() throws Exception {
                DescribeUserHierarchyGroupResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeDescribeUserHierarchyGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserHierarchyStructureResult> describeUserHierarchyStructureAsync(DescribeUserHierarchyStructureRequest request) {
        return this.describeUserHierarchyStructureAsync(request, null);
    }

    @Override
    public Future<DescribeUserHierarchyStructureResult> describeUserHierarchyStructureAsync(DescribeUserHierarchyStructureRequest request, final AsyncHandler<DescribeUserHierarchyStructureRequest, DescribeUserHierarchyStructureResult> asyncHandler) {
        final DescribeUserHierarchyStructureRequest finalRequest = (DescribeUserHierarchyStructureRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeUserHierarchyStructureResult>(){

            @Override
            public DescribeUserHierarchyStructureResult call() throws Exception {
                DescribeUserHierarchyStructureResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeDescribeUserHierarchyStructure(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetContactAttributesResult> getContactAttributesAsync(GetContactAttributesRequest request) {
        return this.getContactAttributesAsync(request, null);
    }

    @Override
    public Future<GetContactAttributesResult> getContactAttributesAsync(GetContactAttributesRequest request, final AsyncHandler<GetContactAttributesRequest, GetContactAttributesResult> asyncHandler) {
        final GetContactAttributesRequest finalRequest = (GetContactAttributesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetContactAttributesResult>(){

            @Override
            public GetContactAttributesResult call() throws Exception {
                GetContactAttributesResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeGetContactAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCurrentMetricDataResult> getCurrentMetricDataAsync(GetCurrentMetricDataRequest request) {
        return this.getCurrentMetricDataAsync(request, null);
    }

    @Override
    public Future<GetCurrentMetricDataResult> getCurrentMetricDataAsync(GetCurrentMetricDataRequest request, final AsyncHandler<GetCurrentMetricDataRequest, GetCurrentMetricDataResult> asyncHandler) {
        final GetCurrentMetricDataRequest finalRequest = (GetCurrentMetricDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCurrentMetricDataResult>(){

            @Override
            public GetCurrentMetricDataResult call() throws Exception {
                GetCurrentMetricDataResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeGetCurrentMetricData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFederationTokenResult> getFederationTokenAsync(GetFederationTokenRequest request) {
        return this.getFederationTokenAsync(request, null);
    }

    @Override
    public Future<GetFederationTokenResult> getFederationTokenAsync(GetFederationTokenRequest request, final AsyncHandler<GetFederationTokenRequest, GetFederationTokenResult> asyncHandler) {
        final GetFederationTokenRequest finalRequest = (GetFederationTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFederationTokenResult>(){

            @Override
            public GetFederationTokenResult call() throws Exception {
                GetFederationTokenResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeGetFederationToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMetricDataResult> getMetricDataAsync(GetMetricDataRequest request) {
        return this.getMetricDataAsync(request, null);
    }

    @Override
    public Future<GetMetricDataResult> getMetricDataAsync(GetMetricDataRequest request, final AsyncHandler<GetMetricDataRequest, GetMetricDataResult> asyncHandler) {
        final GetMetricDataRequest finalRequest = (GetMetricDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMetricDataResult>(){

            @Override
            public GetMetricDataResult call() throws Exception {
                GetMetricDataResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeGetMetricData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListContactFlowsResult> listContactFlowsAsync(ListContactFlowsRequest request) {
        return this.listContactFlowsAsync(request, null);
    }

    @Override
    public Future<ListContactFlowsResult> listContactFlowsAsync(ListContactFlowsRequest request, final AsyncHandler<ListContactFlowsRequest, ListContactFlowsResult> asyncHandler) {
        final ListContactFlowsRequest finalRequest = (ListContactFlowsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListContactFlowsResult>(){

            @Override
            public ListContactFlowsResult call() throws Exception {
                ListContactFlowsResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeListContactFlows(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHoursOfOperationsResult> listHoursOfOperationsAsync(ListHoursOfOperationsRequest request) {
        return this.listHoursOfOperationsAsync(request, null);
    }

    @Override
    public Future<ListHoursOfOperationsResult> listHoursOfOperationsAsync(ListHoursOfOperationsRequest request, final AsyncHandler<ListHoursOfOperationsRequest, ListHoursOfOperationsResult> asyncHandler) {
        final ListHoursOfOperationsRequest finalRequest = (ListHoursOfOperationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListHoursOfOperationsResult>(){

            @Override
            public ListHoursOfOperationsResult call() throws Exception {
                ListHoursOfOperationsResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeListHoursOfOperations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPhoneNumbersResult> listPhoneNumbersAsync(ListPhoneNumbersRequest request) {
        return this.listPhoneNumbersAsync(request, null);
    }

    @Override
    public Future<ListPhoneNumbersResult> listPhoneNumbersAsync(ListPhoneNumbersRequest request, final AsyncHandler<ListPhoneNumbersRequest, ListPhoneNumbersResult> asyncHandler) {
        final ListPhoneNumbersRequest finalRequest = (ListPhoneNumbersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPhoneNumbersResult>(){

            @Override
            public ListPhoneNumbersResult call() throws Exception {
                ListPhoneNumbersResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeListPhoneNumbers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(ListQueuesRequest request) {
        return this.listQueuesAsync(request, null);
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(ListQueuesRequest request, final AsyncHandler<ListQueuesRequest, ListQueuesResult> asyncHandler) {
        final ListQueuesRequest finalRequest = (ListQueuesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListQueuesResult>(){

            @Override
            public ListQueuesResult call() throws Exception {
                ListQueuesResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeListQueues(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRoutingProfilesResult> listRoutingProfilesAsync(ListRoutingProfilesRequest request) {
        return this.listRoutingProfilesAsync(request, null);
    }

    @Override
    public Future<ListRoutingProfilesResult> listRoutingProfilesAsync(ListRoutingProfilesRequest request, final AsyncHandler<ListRoutingProfilesRequest, ListRoutingProfilesResult> asyncHandler) {
        final ListRoutingProfilesRequest finalRequest = (ListRoutingProfilesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRoutingProfilesResult>(){

            @Override
            public ListRoutingProfilesResult call() throws Exception {
                ListRoutingProfilesResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeListRoutingProfiles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSecurityProfilesResult> listSecurityProfilesAsync(ListSecurityProfilesRequest request) {
        return this.listSecurityProfilesAsync(request, null);
    }

    @Override
    public Future<ListSecurityProfilesResult> listSecurityProfilesAsync(ListSecurityProfilesRequest request, final AsyncHandler<ListSecurityProfilesRequest, ListSecurityProfilesResult> asyncHandler) {
        final ListSecurityProfilesRequest finalRequest = (ListSecurityProfilesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSecurityProfilesResult>(){

            @Override
            public ListSecurityProfilesResult call() throws Exception {
                ListSecurityProfilesResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeListSecurityProfiles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUserHierarchyGroupsResult> listUserHierarchyGroupsAsync(ListUserHierarchyGroupsRequest request) {
        return this.listUserHierarchyGroupsAsync(request, null);
    }

    @Override
    public Future<ListUserHierarchyGroupsResult> listUserHierarchyGroupsAsync(ListUserHierarchyGroupsRequest request, final AsyncHandler<ListUserHierarchyGroupsRequest, ListUserHierarchyGroupsResult> asyncHandler) {
        final ListUserHierarchyGroupsRequest finalRequest = (ListUserHierarchyGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUserHierarchyGroupsResult>(){

            @Override
            public ListUserHierarchyGroupsResult call() throws Exception {
                ListUserHierarchyGroupsResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeListUserHierarchyGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request) {
        return this.listUsersAsync(request, null);
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request, final AsyncHandler<ListUsersRequest, ListUsersResult> asyncHandler) {
        final ListUsersRequest finalRequest = (ListUsersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUsersResult>(){

            @Override
            public ListUsersResult call() throws Exception {
                ListUsersResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeListUsers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResumeContactRecordingResult> resumeContactRecordingAsync(ResumeContactRecordingRequest request) {
        return this.resumeContactRecordingAsync(request, null);
    }

    @Override
    public Future<ResumeContactRecordingResult> resumeContactRecordingAsync(ResumeContactRecordingRequest request, final AsyncHandler<ResumeContactRecordingRequest, ResumeContactRecordingResult> asyncHandler) {
        final ResumeContactRecordingRequest finalRequest = (ResumeContactRecordingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResumeContactRecordingResult>(){

            @Override
            public ResumeContactRecordingResult call() throws Exception {
                ResumeContactRecordingResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeResumeContactRecording(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartChatContactResult> startChatContactAsync(StartChatContactRequest request) {
        return this.startChatContactAsync(request, null);
    }

    @Override
    public Future<StartChatContactResult> startChatContactAsync(StartChatContactRequest request, final AsyncHandler<StartChatContactRequest, StartChatContactResult> asyncHandler) {
        final StartChatContactRequest finalRequest = (StartChatContactRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartChatContactResult>(){

            @Override
            public StartChatContactResult call() throws Exception {
                StartChatContactResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeStartChatContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartContactRecordingResult> startContactRecordingAsync(StartContactRecordingRequest request) {
        return this.startContactRecordingAsync(request, null);
    }

    @Override
    public Future<StartContactRecordingResult> startContactRecordingAsync(StartContactRecordingRequest request, final AsyncHandler<StartContactRecordingRequest, StartContactRecordingResult> asyncHandler) {
        final StartContactRecordingRequest finalRequest = (StartContactRecordingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartContactRecordingResult>(){

            @Override
            public StartContactRecordingResult call() throws Exception {
                StartContactRecordingResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeStartContactRecording(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartOutboundVoiceContactResult> startOutboundVoiceContactAsync(StartOutboundVoiceContactRequest request) {
        return this.startOutboundVoiceContactAsync(request, null);
    }

    @Override
    public Future<StartOutboundVoiceContactResult> startOutboundVoiceContactAsync(StartOutboundVoiceContactRequest request, final AsyncHandler<StartOutboundVoiceContactRequest, StartOutboundVoiceContactResult> asyncHandler) {
        final StartOutboundVoiceContactRequest finalRequest = (StartOutboundVoiceContactRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartOutboundVoiceContactResult>(){

            @Override
            public StartOutboundVoiceContactResult call() throws Exception {
                StartOutboundVoiceContactResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeStartOutboundVoiceContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopContactResult> stopContactAsync(StopContactRequest request) {
        return this.stopContactAsync(request, null);
    }

    @Override
    public Future<StopContactResult> stopContactAsync(StopContactRequest request, final AsyncHandler<StopContactRequest, StopContactResult> asyncHandler) {
        final StopContactRequest finalRequest = (StopContactRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopContactResult>(){

            @Override
            public StopContactResult call() throws Exception {
                StopContactResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeStopContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopContactRecordingResult> stopContactRecordingAsync(StopContactRecordingRequest request) {
        return this.stopContactRecordingAsync(request, null);
    }

    @Override
    public Future<StopContactRecordingResult> stopContactRecordingAsync(StopContactRecordingRequest request, final AsyncHandler<StopContactRecordingRequest, StopContactRecordingResult> asyncHandler) {
        final StopContactRecordingRequest finalRequest = (StopContactRecordingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopContactRecordingResult>(){

            @Override
            public StopContactRecordingResult call() throws Exception {
                StopContactRecordingResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeStopContactRecording(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SuspendContactRecordingResult> suspendContactRecordingAsync(SuspendContactRecordingRequest request) {
        return this.suspendContactRecordingAsync(request, null);
    }

    @Override
    public Future<SuspendContactRecordingResult> suspendContactRecordingAsync(SuspendContactRecordingRequest request, final AsyncHandler<SuspendContactRecordingRequest, SuspendContactRecordingResult> asyncHandler) {
        final SuspendContactRecordingRequest finalRequest = (SuspendContactRecordingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SuspendContactRecordingResult>(){

            @Override
            public SuspendContactRecordingResult call() throws Exception {
                SuspendContactRecordingResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeSuspendContactRecording(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateContactAttributesResult> updateContactAttributesAsync(UpdateContactAttributesRequest request) {
        return this.updateContactAttributesAsync(request, null);
    }

    @Override
    public Future<UpdateContactAttributesResult> updateContactAttributesAsync(UpdateContactAttributesRequest request, final AsyncHandler<UpdateContactAttributesRequest, UpdateContactAttributesResult> asyncHandler) {
        final UpdateContactAttributesRequest finalRequest = (UpdateContactAttributesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateContactAttributesResult>(){

            @Override
            public UpdateContactAttributesResult call() throws Exception {
                UpdateContactAttributesResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeUpdateContactAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserHierarchyResult> updateUserHierarchyAsync(UpdateUserHierarchyRequest request) {
        return this.updateUserHierarchyAsync(request, null);
    }

    @Override
    public Future<UpdateUserHierarchyResult> updateUserHierarchyAsync(UpdateUserHierarchyRequest request, final AsyncHandler<UpdateUserHierarchyRequest, UpdateUserHierarchyResult> asyncHandler) {
        final UpdateUserHierarchyRequest finalRequest = (UpdateUserHierarchyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserHierarchyResult>(){

            @Override
            public UpdateUserHierarchyResult call() throws Exception {
                UpdateUserHierarchyResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeUpdateUserHierarchy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserIdentityInfoResult> updateUserIdentityInfoAsync(UpdateUserIdentityInfoRequest request) {
        return this.updateUserIdentityInfoAsync(request, null);
    }

    @Override
    public Future<UpdateUserIdentityInfoResult> updateUserIdentityInfoAsync(UpdateUserIdentityInfoRequest request, final AsyncHandler<UpdateUserIdentityInfoRequest, UpdateUserIdentityInfoResult> asyncHandler) {
        final UpdateUserIdentityInfoRequest finalRequest = (UpdateUserIdentityInfoRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserIdentityInfoResult>(){

            @Override
            public UpdateUserIdentityInfoResult call() throws Exception {
                UpdateUserIdentityInfoResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeUpdateUserIdentityInfo(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserPhoneConfigResult> updateUserPhoneConfigAsync(UpdateUserPhoneConfigRequest request) {
        return this.updateUserPhoneConfigAsync(request, null);
    }

    @Override
    public Future<UpdateUserPhoneConfigResult> updateUserPhoneConfigAsync(UpdateUserPhoneConfigRequest request, final AsyncHandler<UpdateUserPhoneConfigRequest, UpdateUserPhoneConfigResult> asyncHandler) {
        final UpdateUserPhoneConfigRequest finalRequest = (UpdateUserPhoneConfigRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserPhoneConfigResult>(){

            @Override
            public UpdateUserPhoneConfigResult call() throws Exception {
                UpdateUserPhoneConfigResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeUpdateUserPhoneConfig(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserRoutingProfileResult> updateUserRoutingProfileAsync(UpdateUserRoutingProfileRequest request) {
        return this.updateUserRoutingProfileAsync(request, null);
    }

    @Override
    public Future<UpdateUserRoutingProfileResult> updateUserRoutingProfileAsync(UpdateUserRoutingProfileRequest request, final AsyncHandler<UpdateUserRoutingProfileRequest, UpdateUserRoutingProfileResult> asyncHandler) {
        final UpdateUserRoutingProfileRequest finalRequest = (UpdateUserRoutingProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserRoutingProfileResult>(){

            @Override
            public UpdateUserRoutingProfileResult call() throws Exception {
                UpdateUserRoutingProfileResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeUpdateUserRoutingProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserSecurityProfilesResult> updateUserSecurityProfilesAsync(UpdateUserSecurityProfilesRequest request) {
        return this.updateUserSecurityProfilesAsync(request, null);
    }

    @Override
    public Future<UpdateUserSecurityProfilesResult> updateUserSecurityProfilesAsync(UpdateUserSecurityProfilesRequest request, final AsyncHandler<UpdateUserSecurityProfilesRequest, UpdateUserSecurityProfilesResult> asyncHandler) {
        final UpdateUserSecurityProfilesRequest finalRequest = (UpdateUserSecurityProfilesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserSecurityProfilesResult>(){

            @Override
            public UpdateUserSecurityProfilesResult call() throws Exception {
                UpdateUserSecurityProfilesResult result = null;
                try {
                    result = AmazonConnectAsyncClient.this.executeUpdateUserSecurityProfiles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

