/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.ListDiscoveredResourcesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListDiscoveredResourcesRequestMarshaller
implements Marshaller<Request<ListDiscoveredResourcesRequest>, ListDiscoveredResourcesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListDiscoveredResourcesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListDiscoveredResourcesRequest> marshall(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) {
        if (listDiscoveredResourcesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listDiscoveredResourcesRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.ListDiscoveredResources");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList resourceIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listDiscoveredResourcesRequest.getResourceType() != null) {
                jsonGenerator.writeFieldName("resourceType").writeValue(listDiscoveredResourcesRequest.getResourceType());
            }
            if (!(resourceIdsList = (SdkInternalList)listDiscoveredResourcesRequest.getResourceIds()).isEmpty() || !resourceIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("resourceIds");
                jsonGenerator.writeStartArray();
                for (String resourceIdsListValue : resourceIdsList) {
                    if (resourceIdsListValue == null) continue;
                    jsonGenerator.writeValue(resourceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listDiscoveredResourcesRequest.getResourceName() != null) {
                jsonGenerator.writeFieldName("resourceName").writeValue(listDiscoveredResourcesRequest.getResourceName());
            }
            if (listDiscoveredResourcesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("limit").writeValue(listDiscoveredResourcesRequest.getLimit().intValue());
            }
            if (listDiscoveredResourcesRequest.getIncludeDeletedResources() != null) {
                jsonGenerator.writeFieldName("includeDeletedResources").writeValue(listDiscoveredResourcesRequest.getIncludeDeletedResources().booleanValue());
            }
            if (listDiscoveredResourcesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listDiscoveredResourcesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

