/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.config.model.Owner;
import com.amazonaws.services.config.model.SourceDetail;
import com.amazonaws.services.config.model.transform.SourceMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Source
implements Serializable,
Cloneable,
StructuredPojo {
    private String owner;
    private String sourceIdentifier;
    private SdkInternalList<SourceDetail> sourceDetails;

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    public Source withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    @JsonIgnore
    public void setOwner(Owner owner) {
        this.withOwner(owner);
    }

    public Source withOwner(Owner owner) {
        this.owner = owner.toString();
        return this;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public Source withSourceIdentifier(String sourceIdentifier) {
        this.setSourceIdentifier(sourceIdentifier);
        return this;
    }

    public List<SourceDetail> getSourceDetails() {
        if (this.sourceDetails == null) {
            this.sourceDetails = new SdkInternalList();
        }
        return this.sourceDetails;
    }

    public void setSourceDetails(Collection<SourceDetail> sourceDetails) {
        if (sourceDetails == null) {
            this.sourceDetails = null;
            return;
        }
        this.sourceDetails = new SdkInternalList(sourceDetails);
    }

    public Source withSourceDetails(SourceDetail ... sourceDetails) {
        if (this.sourceDetails == null) {
            this.setSourceDetails((Collection<SourceDetail>)new SdkInternalList(sourceDetails.length));
        }
        for (SourceDetail ele : sourceDetails) {
            this.sourceDetails.add((Object)ele);
        }
        return this;
    }

    public Source withSourceDetails(Collection<SourceDetail> sourceDetails) {
        this.setSourceDetails(sourceDetails);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getSourceIdentifier() != null) {
            sb.append("SourceIdentifier: ").append(this.getSourceIdentifier()).append(",");
        }
        if (this.getSourceDetails() != null) {
            sb.append("SourceDetails: ").append(this.getSourceDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getSourceIdentifier() == null ^ this.getSourceIdentifier() == null) {
            return false;
        }
        if (other.getSourceIdentifier() != null && !other.getSourceIdentifier().equals(this.getSourceIdentifier())) {
            return false;
        }
        if (other.getSourceDetails() == null ^ this.getSourceDetails() == null) {
            return false;
        }
        return other.getSourceDetails() == null || other.getSourceDetails().equals(this.getSourceDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getSourceIdentifier() == null ? 0 : this.getSourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSourceDetails() == null ? 0 : this.getSourceDetails().hashCode());
        return hashCode;
    }

    public Source clone() {
        try {
            return (Source)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

