/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeDeliveryChannelsRequestMarshaller
implements Marshaller<Request<DescribeDeliveryChannelsRequest>, DescribeDeliveryChannelsRequest> {
    public Request<DescribeDeliveryChannelsRequest> marshall(DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) {
        if (describeDeliveryChannelsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDeliveryChannelsRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DescribeDeliveryChannels");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList deliveryChannelNamesList = (SdkInternalList)describeDeliveryChannelsRequest.getDeliveryChannelNames();
            if (!deliveryChannelNamesList.isEmpty() || !deliveryChannelNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DeliveryChannelNames");
                jsonGenerator.writeStartArray();
                for (String deliveryChannelNamesListValue : deliveryChannelNamesList) {
                    if (deliveryChannelNamesListValue == null) continue;
                    jsonGenerator.writeValue(deliveryChannelNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

