/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.config.AmazonConfigAsync;
import com.amazonaws.services.config.AmazonConfigClient;
import com.amazonaws.services.config.model.DeleteConfigRuleRequest;
import com.amazonaws.services.config.model.DeleteDeliveryChannelRequest;
import com.amazonaws.services.config.model.DeliverConfigSnapshotRequest;
import com.amazonaws.services.config.model.DeliverConfigSnapshotResult;
import com.amazonaws.services.config.model.DescribeComplianceByConfigRuleRequest;
import com.amazonaws.services.config.model.DescribeComplianceByConfigRuleResult;
import com.amazonaws.services.config.model.DescribeComplianceByResourceRequest;
import com.amazonaws.services.config.model.DescribeComplianceByResourceResult;
import com.amazonaws.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import com.amazonaws.services.config.model.DescribeConfigRuleEvaluationStatusResult;
import com.amazonaws.services.config.model.DescribeConfigRulesRequest;
import com.amazonaws.services.config.model.DescribeConfigRulesResult;
import com.amazonaws.services.config.model.DescribeConfigurationRecorderStatusRequest;
import com.amazonaws.services.config.model.DescribeConfigurationRecorderStatusResult;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersRequest;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersResult;
import com.amazonaws.services.config.model.DescribeDeliveryChannelStatusRequest;
import com.amazonaws.services.config.model.DescribeDeliveryChannelStatusResult;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsRequest;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsResult;
import com.amazonaws.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import com.amazonaws.services.config.model.GetComplianceDetailsByConfigRuleResult;
import com.amazonaws.services.config.model.GetComplianceDetailsByResourceRequest;
import com.amazonaws.services.config.model.GetComplianceDetailsByResourceResult;
import com.amazonaws.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import com.amazonaws.services.config.model.GetComplianceSummaryByConfigRuleResult;
import com.amazonaws.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import com.amazonaws.services.config.model.GetComplianceSummaryByResourceTypeResult;
import com.amazonaws.services.config.model.GetResourceConfigHistoryRequest;
import com.amazonaws.services.config.model.GetResourceConfigHistoryResult;
import com.amazonaws.services.config.model.ListDiscoveredResourcesRequest;
import com.amazonaws.services.config.model.ListDiscoveredResourcesResult;
import com.amazonaws.services.config.model.PutConfigRuleRequest;
import com.amazonaws.services.config.model.PutConfigurationRecorderRequest;
import com.amazonaws.services.config.model.PutDeliveryChannelRequest;
import com.amazonaws.services.config.model.PutEvaluationsRequest;
import com.amazonaws.services.config.model.PutEvaluationsResult;
import com.amazonaws.services.config.model.StartConfigurationRecorderRequest;
import com.amazonaws.services.config.model.StopConfigurationRecorderRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonConfigAsyncClient
extends AmazonConfigClient
implements AmazonConfigAsync {
    private final ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonConfigAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonConfigAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonConfigAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonConfigAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonConfigAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<GetComplianceDetailsByResourceResult> getComplianceDetailsByResourceAsync(final GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetComplianceDetailsByResourceResult>(){

            @Override
            public GetComplianceDetailsByResourceResult call() throws Exception {
                return AmazonConfigAsyncClient.this.getComplianceDetailsByResource(getComplianceDetailsByResourceRequest);
            }
        });
    }

    @Override
    public Future<GetComplianceDetailsByResourceResult> getComplianceDetailsByResourceAsync(final GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest, final AsyncHandler<GetComplianceDetailsByResourceRequest, GetComplianceDetailsByResourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetComplianceDetailsByResourceResult>(){

            @Override
            public GetComplianceDetailsByResourceResult call() throws Exception {
                GetComplianceDetailsByResourceResult result;
                try {
                    result = AmazonConfigAsyncClient.this.getComplianceDetailsByResource(getComplianceDetailsByResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getComplianceDetailsByResourceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<PutEvaluationsResult> putEvaluationsAsync(final PutEvaluationsRequest putEvaluationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutEvaluationsResult>(){

            @Override
            public PutEvaluationsResult call() throws Exception {
                return AmazonConfigAsyncClient.this.putEvaluations(putEvaluationsRequest);
            }
        });
    }

    @Override
    public Future<PutEvaluationsResult> putEvaluationsAsync(final PutEvaluationsRequest putEvaluationsRequest, final AsyncHandler<PutEvaluationsRequest, PutEvaluationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<PutEvaluationsResult>(){

            @Override
            public PutEvaluationsResult call() throws Exception {
                PutEvaluationsResult result;
                try {
                    result = AmazonConfigAsyncClient.this.putEvaluations(putEvaluationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putEvaluationsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetComplianceSummaryByConfigRuleResult> getComplianceSummaryByConfigRuleAsync(final GetComplianceSummaryByConfigRuleRequest getComplianceSummaryByConfigRuleRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetComplianceSummaryByConfigRuleResult>(){

            @Override
            public GetComplianceSummaryByConfigRuleResult call() throws Exception {
                return AmazonConfigAsyncClient.this.getComplianceSummaryByConfigRule(getComplianceSummaryByConfigRuleRequest);
            }
        });
    }

    @Override
    public Future<GetComplianceSummaryByConfigRuleResult> getComplianceSummaryByConfigRuleAsync(final GetComplianceSummaryByConfigRuleRequest getComplianceSummaryByConfigRuleRequest, final AsyncHandler<GetComplianceSummaryByConfigRuleRequest, GetComplianceSummaryByConfigRuleResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetComplianceSummaryByConfigRuleResult>(){

            @Override
            public GetComplianceSummaryByConfigRuleResult call() throws Exception {
                GetComplianceSummaryByConfigRuleResult result;
                try {
                    result = AmazonConfigAsyncClient.this.getComplianceSummaryByConfigRule(getComplianceSummaryByConfigRuleRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getComplianceSummaryByConfigRuleRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetComplianceSummaryByResourceTypeResult> getComplianceSummaryByResourceTypeAsync(final GetComplianceSummaryByResourceTypeRequest getComplianceSummaryByResourceTypeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetComplianceSummaryByResourceTypeResult>(){

            @Override
            public GetComplianceSummaryByResourceTypeResult call() throws Exception {
                return AmazonConfigAsyncClient.this.getComplianceSummaryByResourceType(getComplianceSummaryByResourceTypeRequest);
            }
        });
    }

    @Override
    public Future<GetComplianceSummaryByResourceTypeResult> getComplianceSummaryByResourceTypeAsync(final GetComplianceSummaryByResourceTypeRequest getComplianceSummaryByResourceTypeRequest, final AsyncHandler<GetComplianceSummaryByResourceTypeRequest, GetComplianceSummaryByResourceTypeResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetComplianceSummaryByResourceTypeResult>(){

            @Override
            public GetComplianceSummaryByResourceTypeResult call() throws Exception {
                GetComplianceSummaryByResourceTypeResult result;
                try {
                    result = AmazonConfigAsyncClient.this.getComplianceSummaryByResourceType(getComplianceSummaryByResourceTypeRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getComplianceSummaryByResourceTypeRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeComplianceByConfigRuleResult> describeComplianceByConfigRuleAsync(final DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeComplianceByConfigRuleResult>(){

            @Override
            public DescribeComplianceByConfigRuleResult call() throws Exception {
                return AmazonConfigAsyncClient.this.describeComplianceByConfigRule(describeComplianceByConfigRuleRequest);
            }
        });
    }

    @Override
    public Future<DescribeComplianceByConfigRuleResult> describeComplianceByConfigRuleAsync(final DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest, final AsyncHandler<DescribeComplianceByConfigRuleRequest, DescribeComplianceByConfigRuleResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeComplianceByConfigRuleResult>(){

            @Override
            public DescribeComplianceByConfigRuleResult call() throws Exception {
                DescribeComplianceByConfigRuleResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeComplianceByConfigRule(describeComplianceByConfigRuleRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeComplianceByConfigRuleRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> startConfigurationRecorderAsync(final StartConfigurationRecorderRequest startConfigurationRecorderRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonConfigAsyncClient.this.startConfigurationRecorder(startConfigurationRecorderRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> startConfigurationRecorderAsync(final StartConfigurationRecorderRequest startConfigurationRecorderRequest, final AsyncHandler<StartConfigurationRecorderRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonConfigAsyncClient.this.startConfigurationRecorder(startConfigurationRecorderRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)startConfigurationRecorderRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putDeliveryChannelAsync(final PutDeliveryChannelRequest putDeliveryChannelRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonConfigAsyncClient.this.putDeliveryChannel(putDeliveryChannelRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putDeliveryChannelAsync(final PutDeliveryChannelRequest putDeliveryChannelRequest, final AsyncHandler<PutDeliveryChannelRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonConfigAsyncClient.this.putDeliveryChannel(putDeliveryChannelRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putDeliveryChannelRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<GetComplianceDetailsByConfigRuleResult> getComplianceDetailsByConfigRuleAsync(final GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetComplianceDetailsByConfigRuleResult>(){

            @Override
            public GetComplianceDetailsByConfigRuleResult call() throws Exception {
                return AmazonConfigAsyncClient.this.getComplianceDetailsByConfigRule(getComplianceDetailsByConfigRuleRequest);
            }
        });
    }

    @Override
    public Future<GetComplianceDetailsByConfigRuleResult> getComplianceDetailsByConfigRuleAsync(final GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest, final AsyncHandler<GetComplianceDetailsByConfigRuleRequest, GetComplianceDetailsByConfigRuleResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetComplianceDetailsByConfigRuleResult>(){

            @Override
            public GetComplianceDetailsByConfigRuleResult call() throws Exception {
                GetComplianceDetailsByConfigRuleResult result;
                try {
                    result = AmazonConfigAsyncClient.this.getComplianceDetailsByConfigRule(getComplianceDetailsByConfigRuleRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getComplianceDetailsByConfigRuleRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigRuleEvaluationStatusResult> describeConfigRuleEvaluationStatusAsync(final DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigRuleEvaluationStatusResult>(){

            @Override
            public DescribeConfigRuleEvaluationStatusResult call() throws Exception {
                return AmazonConfigAsyncClient.this.describeConfigRuleEvaluationStatus(describeConfigRuleEvaluationStatusRequest);
            }
        });
    }

    @Override
    public Future<DescribeConfigRuleEvaluationStatusResult> describeConfigRuleEvaluationStatusAsync(final DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest, final AsyncHandler<DescribeConfigRuleEvaluationStatusRequest, DescribeConfigRuleEvaluationStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigRuleEvaluationStatusResult>(){

            @Override
            public DescribeConfigRuleEvaluationStatusResult call() throws Exception {
                DescribeConfigRuleEvaluationStatusResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeConfigRuleEvaluationStatus(describeConfigRuleEvaluationStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeConfigRuleEvaluationStatusRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeliveryChannelsResult> describeDeliveryChannelsAsync(final DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDeliveryChannelsResult>(){

            @Override
            public DescribeDeliveryChannelsResult call() throws Exception {
                return AmazonConfigAsyncClient.this.describeDeliveryChannels(describeDeliveryChannelsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDeliveryChannelsResult> describeDeliveryChannelsAsync(final DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest, final AsyncHandler<DescribeDeliveryChannelsRequest, DescribeDeliveryChannelsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDeliveryChannelsResult>(){

            @Override
            public DescribeDeliveryChannelsResult call() throws Exception {
                DescribeDeliveryChannelsResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeDeliveryChannels(describeDeliveryChannelsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDeliveryChannelsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeliveryChannelStatusResult> describeDeliveryChannelStatusAsync(final DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDeliveryChannelStatusResult>(){

            @Override
            public DescribeDeliveryChannelStatusResult call() throws Exception {
                return AmazonConfigAsyncClient.this.describeDeliveryChannelStatus(describeDeliveryChannelStatusRequest);
            }
        });
    }

    @Override
    public Future<DescribeDeliveryChannelStatusResult> describeDeliveryChannelStatusAsync(final DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest, final AsyncHandler<DescribeDeliveryChannelStatusRequest, DescribeDeliveryChannelStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDeliveryChannelStatusResult>(){

            @Override
            public DescribeDeliveryChannelStatusResult call() throws Exception {
                DescribeDeliveryChannelStatusResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeDeliveryChannelStatus(describeDeliveryChannelStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDeliveryChannelStatusRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRecordersResult> describeConfigurationRecordersAsync(final DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigurationRecordersResult>(){

            @Override
            public DescribeConfigurationRecordersResult call() throws Exception {
                return AmazonConfigAsyncClient.this.describeConfigurationRecorders(describeConfigurationRecordersRequest);
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRecordersResult> describeConfigurationRecordersAsync(final DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest, final AsyncHandler<DescribeConfigurationRecordersRequest, DescribeConfigurationRecordersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigurationRecordersResult>(){

            @Override
            public DescribeConfigurationRecordersResult call() throws Exception {
                DescribeConfigurationRecordersResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeConfigurationRecorders(describeConfigurationRecordersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeConfigurationRecordersRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putConfigRuleAsync(final PutConfigRuleRequest putConfigRuleRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonConfigAsyncClient.this.putConfigRule(putConfigRuleRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putConfigRuleAsync(final PutConfigRuleRequest putConfigRuleRequest, final AsyncHandler<PutConfigRuleRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonConfigAsyncClient.this.putConfigRule(putConfigRuleRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putConfigRuleRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteConfigRuleAsync(final DeleteConfigRuleRequest deleteConfigRuleRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonConfigAsyncClient.this.deleteConfigRule(deleteConfigRuleRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteConfigRuleAsync(final DeleteConfigRuleRequest deleteConfigRuleRequest, final AsyncHandler<DeleteConfigRuleRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonConfigAsyncClient.this.deleteConfigRule(deleteConfigRuleRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteConfigRuleRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDeliveryChannelAsync(final DeleteDeliveryChannelRequest deleteDeliveryChannelRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonConfigAsyncClient.this.deleteDeliveryChannel(deleteDeliveryChannelRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDeliveryChannelAsync(final DeleteDeliveryChannelRequest deleteDeliveryChannelRequest, final AsyncHandler<DeleteDeliveryChannelRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonConfigAsyncClient.this.deleteDeliveryChannel(deleteDeliveryChannelRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteDeliveryChannelRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeConfigRulesResult> describeConfigRulesAsync(final DescribeConfigRulesRequest describeConfigRulesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigRulesResult>(){

            @Override
            public DescribeConfigRulesResult call() throws Exception {
                return AmazonConfigAsyncClient.this.describeConfigRules(describeConfigRulesRequest);
            }
        });
    }

    @Override
    public Future<DescribeConfigRulesResult> describeConfigRulesAsync(final DescribeConfigRulesRequest describeConfigRulesRequest, final AsyncHandler<DescribeConfigRulesRequest, DescribeConfigRulesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigRulesResult>(){

            @Override
            public DescribeConfigRulesResult call() throws Exception {
                DescribeConfigRulesResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeConfigRules(describeConfigRulesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeConfigRulesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> stopConfigurationRecorderAsync(final StopConfigurationRecorderRequest stopConfigurationRecorderRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonConfigAsyncClient.this.stopConfigurationRecorder(stopConfigurationRecorderRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> stopConfigurationRecorderAsync(final StopConfigurationRecorderRequest stopConfigurationRecorderRequest, final AsyncHandler<StopConfigurationRecorderRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonConfigAsyncClient.this.stopConfigurationRecorder(stopConfigurationRecorderRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)stopConfigurationRecorderRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DeliverConfigSnapshotResult> deliverConfigSnapshotAsync(final DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeliverConfigSnapshotResult>(){

            @Override
            public DeliverConfigSnapshotResult call() throws Exception {
                return AmazonConfigAsyncClient.this.deliverConfigSnapshot(deliverConfigSnapshotRequest);
            }
        });
    }

    @Override
    public Future<DeliverConfigSnapshotResult> deliverConfigSnapshotAsync(final DeliverConfigSnapshotRequest deliverConfigSnapshotRequest, final AsyncHandler<DeliverConfigSnapshotRequest, DeliverConfigSnapshotResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeliverConfigSnapshotResult>(){

            @Override
            public DeliverConfigSnapshotResult call() throws Exception {
                DeliverConfigSnapshotResult result;
                try {
                    result = AmazonConfigAsyncClient.this.deliverConfigSnapshot(deliverConfigSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deliverConfigSnapshotRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putConfigurationRecorderAsync(final PutConfigurationRecorderRequest putConfigurationRecorderRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonConfigAsyncClient.this.putConfigurationRecorder(putConfigurationRecorderRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putConfigurationRecorderAsync(final PutConfigurationRecorderRequest putConfigurationRecorderRequest, final AsyncHandler<PutConfigurationRecorderRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonConfigAsyncClient.this.putConfigurationRecorder(putConfigurationRecorderRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putConfigurationRecorderRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeComplianceByResourceResult> describeComplianceByResourceAsync(final DescribeComplianceByResourceRequest describeComplianceByResourceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeComplianceByResourceResult>(){

            @Override
            public DescribeComplianceByResourceResult call() throws Exception {
                return AmazonConfigAsyncClient.this.describeComplianceByResource(describeComplianceByResourceRequest);
            }
        });
    }

    @Override
    public Future<DescribeComplianceByResourceResult> describeComplianceByResourceAsync(final DescribeComplianceByResourceRequest describeComplianceByResourceRequest, final AsyncHandler<DescribeComplianceByResourceRequest, DescribeComplianceByResourceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeComplianceByResourceResult>(){

            @Override
            public DescribeComplianceByResourceResult call() throws Exception {
                DescribeComplianceByResourceResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeComplianceByResource(describeComplianceByResourceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeComplianceByResourceRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceConfigHistoryResult> getResourceConfigHistoryAsync(final GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetResourceConfigHistoryResult>(){

            @Override
            public GetResourceConfigHistoryResult call() throws Exception {
                return AmazonConfigAsyncClient.this.getResourceConfigHistory(getResourceConfigHistoryRequest);
            }
        });
    }

    @Override
    public Future<GetResourceConfigHistoryResult> getResourceConfigHistoryAsync(final GetResourceConfigHistoryRequest getResourceConfigHistoryRequest, final AsyncHandler<GetResourceConfigHistoryRequest, GetResourceConfigHistoryResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetResourceConfigHistoryResult>(){

            @Override
            public GetResourceConfigHistoryResult call() throws Exception {
                GetResourceConfigHistoryResult result;
                try {
                    result = AmazonConfigAsyncClient.this.getResourceConfigHistory(getResourceConfigHistoryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getResourceConfigHistoryRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListDiscoveredResourcesResult> listDiscoveredResourcesAsync(final ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDiscoveredResourcesResult>(){

            @Override
            public ListDiscoveredResourcesResult call() throws Exception {
                return AmazonConfigAsyncClient.this.listDiscoveredResources(listDiscoveredResourcesRequest);
            }
        });
    }

    @Override
    public Future<ListDiscoveredResourcesResult> listDiscoveredResourcesAsync(final ListDiscoveredResourcesRequest listDiscoveredResourcesRequest, final AsyncHandler<ListDiscoveredResourcesRequest, ListDiscoveredResourcesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDiscoveredResourcesResult>(){

            @Override
            public ListDiscoveredResourcesResult call() throws Exception {
                ListDiscoveredResourcesResult result;
                try {
                    result = AmazonConfigAsyncClient.this.listDiscoveredResources(listDiscoveredResourcesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listDiscoveredResourcesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRecorderStatusResult> describeConfigurationRecorderStatusAsync(final DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigurationRecorderStatusResult>(){

            @Override
            public DescribeConfigurationRecorderStatusResult call() throws Exception {
                return AmazonConfigAsyncClient.this.describeConfigurationRecorderStatus(describeConfigurationRecorderStatusRequest);
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRecorderStatusResult> describeConfigurationRecorderStatusAsync(final DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest, final AsyncHandler<DescribeConfigurationRecorderStatusRequest, DescribeConfigurationRecorderStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigurationRecorderStatusResult>(){

            @Override
            public DescribeConfigurationRecorderStatusResult call() throws Exception {
                DescribeConfigurationRecorderStatusResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeConfigurationRecorderStatus(describeConfigurationRecorderStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeConfigurationRecorderStatusRequest, (Object)result);
                return result;
            }
        });
    }
}

