/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.computeoptimizer.AWSComputeOptimizer;
import com.amazonaws.services.computeoptimizer.AWSComputeOptimizerClientBuilder;
import com.amazonaws.services.computeoptimizer.model.AWSComputeOptimizerException;
import com.amazonaws.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest;
import com.amazonaws.services.computeoptimizer.model.DescribeRecommendationExportJobsResult;
import com.amazonaws.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.ExportEBSVolumeRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportEBSVolumeRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.ExportEC2InstanceRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportEC2InstanceRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetEBSVolumeRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetEBSVolumeRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetEC2InstanceRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetEC2InstanceRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetEC2RecommendationProjectedMetricsRequest;
import com.amazonaws.services.computeoptimizer.model.GetEC2RecommendationProjectedMetricsResult;
import com.amazonaws.services.computeoptimizer.model.GetEnrollmentStatusRequest;
import com.amazonaws.services.computeoptimizer.model.GetEnrollmentStatusResult;
import com.amazonaws.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest;
import com.amazonaws.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResult;
import com.amazonaws.services.computeoptimizer.model.GetRecommendationSummariesRequest;
import com.amazonaws.services.computeoptimizer.model.GetRecommendationSummariesResult;
import com.amazonaws.services.computeoptimizer.model.UpdateEnrollmentStatusRequest;
import com.amazonaws.services.computeoptimizer.model.UpdateEnrollmentStatusResult;
import com.amazonaws.services.computeoptimizer.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.DescribeRecommendationExportJobsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.DescribeRecommendationExportJobsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportAutoScalingGroupRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportAutoScalingGroupRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportEBSVolumeRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportEBSVolumeRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportEC2InstanceRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportEC2InstanceRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportLambdaFunctionRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ExportLambdaFunctionRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetAutoScalingGroupRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetAutoScalingGroupRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEBSVolumeRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEBSVolumeRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEC2InstanceRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEC2InstanceRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEC2RecommendationProjectedMetricsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEC2RecommendationProjectedMetricsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEnrollmentStatusRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetEnrollmentStatusResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetLambdaFunctionRecommendationsRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetLambdaFunctionRecommendationsResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetRecommendationSummariesRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.GetRecommendationSummariesResultJsonUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.MissingAuthenticationTokenExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.OptInRequiredExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.UpdateEnrollmentStatusRequestProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.transform.UpdateEnrollmentStatusResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSComputeOptimizerClient
extends AmazonWebServiceClient
implements AWSComputeOptimizer {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSComputeOptimizer.class);
    private static final String DEFAULT_SIGNING_NAME = "compute-optimizer";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidParameterValueExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MissingAuthenticationToken").withExceptionUnmarshaller((JsonErrorUnmarshaller)MissingAuthenticationTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OptInRequiredException").withExceptionUnmarshaller((JsonErrorUnmarshaller)OptInRequiredExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSComputeOptimizerException.class));

    public static AWSComputeOptimizerClientBuilder builder() {
        return AWSComputeOptimizerClientBuilder.standard();
    }

    AWSComputeOptimizerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSComputeOptimizerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("compute-optimizer.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/computeoptimizer/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/computeoptimizer/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DescribeRecommendationExportJobsResult describeRecommendationExportJobs(DescribeRecommendationExportJobsRequest request) {
        request = (DescribeRecommendationExportJobsRequest)this.beforeClientExecution(request);
        return this.executeDescribeRecommendationExportJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRecommendationExportJobsResult executeDescribeRecommendationExportJobs(DescribeRecommendationExportJobsRequest describeRecommendationExportJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRecommendationExportJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRecommendationExportJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRecommendationExportJobsRequestProtocolMarshaller(protocolFactory).marshall((DescribeRecommendationExportJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRecommendationExportJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeRecommendationExportJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRecommendationExportJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRecommendationExportJobsResult describeRecommendationExportJobsResult = (DescribeRecommendationExportJobsResult)response.getAwsResponse();
            return describeRecommendationExportJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportAutoScalingGroupRecommendationsResult exportAutoScalingGroupRecommendations(ExportAutoScalingGroupRecommendationsRequest request) {
        request = (ExportAutoScalingGroupRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeExportAutoScalingGroupRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportAutoScalingGroupRecommendationsResult executeExportAutoScalingGroupRecommendations(ExportAutoScalingGroupRecommendationsRequest exportAutoScalingGroupRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportAutoScalingGroupRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportAutoScalingGroupRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportAutoScalingGroupRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ExportAutoScalingGroupRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportAutoScalingGroupRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportAutoScalingGroupRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportAutoScalingGroupRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportAutoScalingGroupRecommendationsResult exportAutoScalingGroupRecommendationsResult = (ExportAutoScalingGroupRecommendationsResult)response.getAwsResponse();
            return exportAutoScalingGroupRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportEBSVolumeRecommendationsResult exportEBSVolumeRecommendations(ExportEBSVolumeRecommendationsRequest request) {
        request = (ExportEBSVolumeRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeExportEBSVolumeRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportEBSVolumeRecommendationsResult executeExportEBSVolumeRecommendations(ExportEBSVolumeRecommendationsRequest exportEBSVolumeRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportEBSVolumeRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportEBSVolumeRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportEBSVolumeRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ExportEBSVolumeRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportEBSVolumeRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportEBSVolumeRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportEBSVolumeRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportEBSVolumeRecommendationsResult exportEBSVolumeRecommendationsResult = (ExportEBSVolumeRecommendationsResult)response.getAwsResponse();
            return exportEBSVolumeRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportEC2InstanceRecommendationsResult exportEC2InstanceRecommendations(ExportEC2InstanceRecommendationsRequest request) {
        request = (ExportEC2InstanceRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeExportEC2InstanceRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportEC2InstanceRecommendationsResult executeExportEC2InstanceRecommendations(ExportEC2InstanceRecommendationsRequest exportEC2InstanceRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportEC2InstanceRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportEC2InstanceRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportEC2InstanceRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ExportEC2InstanceRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportEC2InstanceRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportEC2InstanceRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportEC2InstanceRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportEC2InstanceRecommendationsResult exportEC2InstanceRecommendationsResult = (ExportEC2InstanceRecommendationsResult)response.getAwsResponse();
            return exportEC2InstanceRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ExportLambdaFunctionRecommendationsResult exportLambdaFunctionRecommendations(ExportLambdaFunctionRecommendationsRequest request) {
        request = (ExportLambdaFunctionRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeExportLambdaFunctionRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ExportLambdaFunctionRecommendationsResult executeExportLambdaFunctionRecommendations(ExportLambdaFunctionRecommendationsRequest exportLambdaFunctionRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(exportLambdaFunctionRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ExportLambdaFunctionRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ExportLambdaFunctionRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((ExportLambdaFunctionRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)exportLambdaFunctionRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ExportLambdaFunctionRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ExportLambdaFunctionRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ExportLambdaFunctionRecommendationsResult exportLambdaFunctionRecommendationsResult = (ExportLambdaFunctionRecommendationsResult)response.getAwsResponse();
            return exportLambdaFunctionRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAutoScalingGroupRecommendationsResult getAutoScalingGroupRecommendations(GetAutoScalingGroupRecommendationsRequest request) {
        request = (GetAutoScalingGroupRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeGetAutoScalingGroupRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAutoScalingGroupRecommendationsResult executeGetAutoScalingGroupRecommendations(GetAutoScalingGroupRecommendationsRequest getAutoScalingGroupRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAutoScalingGroupRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAutoScalingGroupRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAutoScalingGroupRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((GetAutoScalingGroupRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAutoScalingGroupRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAutoScalingGroupRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAutoScalingGroupRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAutoScalingGroupRecommendationsResult getAutoScalingGroupRecommendationsResult = (GetAutoScalingGroupRecommendationsResult)response.getAwsResponse();
            return getAutoScalingGroupRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEBSVolumeRecommendationsResult getEBSVolumeRecommendations(GetEBSVolumeRecommendationsRequest request) {
        request = (GetEBSVolumeRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeGetEBSVolumeRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEBSVolumeRecommendationsResult executeGetEBSVolumeRecommendations(GetEBSVolumeRecommendationsRequest getEBSVolumeRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEBSVolumeRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEBSVolumeRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEBSVolumeRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((GetEBSVolumeRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEBSVolumeRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEBSVolumeRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEBSVolumeRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEBSVolumeRecommendationsResult getEBSVolumeRecommendationsResult = (GetEBSVolumeRecommendationsResult)response.getAwsResponse();
            return getEBSVolumeRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEC2InstanceRecommendationsResult getEC2InstanceRecommendations(GetEC2InstanceRecommendationsRequest request) {
        request = (GetEC2InstanceRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeGetEC2InstanceRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEC2InstanceRecommendationsResult executeGetEC2InstanceRecommendations(GetEC2InstanceRecommendationsRequest getEC2InstanceRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEC2InstanceRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEC2InstanceRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEC2InstanceRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((GetEC2InstanceRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEC2InstanceRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEC2InstanceRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEC2InstanceRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEC2InstanceRecommendationsResult getEC2InstanceRecommendationsResult = (GetEC2InstanceRecommendationsResult)response.getAwsResponse();
            return getEC2InstanceRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEC2RecommendationProjectedMetricsResult getEC2RecommendationProjectedMetrics(GetEC2RecommendationProjectedMetricsRequest request) {
        request = (GetEC2RecommendationProjectedMetricsRequest)this.beforeClientExecution(request);
        return this.executeGetEC2RecommendationProjectedMetrics(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEC2RecommendationProjectedMetricsResult executeGetEC2RecommendationProjectedMetrics(GetEC2RecommendationProjectedMetricsRequest getEC2RecommendationProjectedMetricsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEC2RecommendationProjectedMetricsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEC2RecommendationProjectedMetricsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEC2RecommendationProjectedMetricsRequestProtocolMarshaller(protocolFactory).marshall((GetEC2RecommendationProjectedMetricsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEC2RecommendationProjectedMetricsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEC2RecommendationProjectedMetrics");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEC2RecommendationProjectedMetricsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEC2RecommendationProjectedMetricsResult getEC2RecommendationProjectedMetricsResult = (GetEC2RecommendationProjectedMetricsResult)response.getAwsResponse();
            return getEC2RecommendationProjectedMetricsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEnrollmentStatusResult getEnrollmentStatus(GetEnrollmentStatusRequest request) {
        request = (GetEnrollmentStatusRequest)this.beforeClientExecution(request);
        return this.executeGetEnrollmentStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEnrollmentStatusResult executeGetEnrollmentStatus(GetEnrollmentStatusRequest getEnrollmentStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEnrollmentStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEnrollmentStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEnrollmentStatusRequestProtocolMarshaller(protocolFactory).marshall((GetEnrollmentStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEnrollmentStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEnrollmentStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEnrollmentStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEnrollmentStatusResult getEnrollmentStatusResult = (GetEnrollmentStatusResult)response.getAwsResponse();
            return getEnrollmentStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLambdaFunctionRecommendationsResult getLambdaFunctionRecommendations(GetLambdaFunctionRecommendationsRequest request) {
        request = (GetLambdaFunctionRecommendationsRequest)this.beforeClientExecution(request);
        return this.executeGetLambdaFunctionRecommendations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLambdaFunctionRecommendationsResult executeGetLambdaFunctionRecommendations(GetLambdaFunctionRecommendationsRequest getLambdaFunctionRecommendationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLambdaFunctionRecommendationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLambdaFunctionRecommendationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLambdaFunctionRecommendationsRequestProtocolMarshaller(protocolFactory).marshall((GetLambdaFunctionRecommendationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLambdaFunctionRecommendationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLambdaFunctionRecommendations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLambdaFunctionRecommendationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLambdaFunctionRecommendationsResult getLambdaFunctionRecommendationsResult = (GetLambdaFunctionRecommendationsResult)response.getAwsResponse();
            return getLambdaFunctionRecommendationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRecommendationSummariesResult getRecommendationSummaries(GetRecommendationSummariesRequest request) {
        request = (GetRecommendationSummariesRequest)this.beforeClientExecution(request);
        return this.executeGetRecommendationSummaries(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRecommendationSummariesResult executeGetRecommendationSummaries(GetRecommendationSummariesRequest getRecommendationSummariesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRecommendationSummariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRecommendationSummariesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRecommendationSummariesRequestProtocolMarshaller(protocolFactory).marshall((GetRecommendationSummariesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRecommendationSummariesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRecommendationSummaries");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRecommendationSummariesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRecommendationSummariesResult getRecommendationSummariesResult = (GetRecommendationSummariesResult)response.getAwsResponse();
            return getRecommendationSummariesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateEnrollmentStatusResult updateEnrollmentStatus(UpdateEnrollmentStatusRequest request) {
        request = (UpdateEnrollmentStatusRequest)this.beforeClientExecution(request);
        return this.executeUpdateEnrollmentStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateEnrollmentStatusResult executeUpdateEnrollmentStatus(UpdateEnrollmentStatusRequest updateEnrollmentStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEnrollmentStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEnrollmentStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEnrollmentStatusRequestProtocolMarshaller(protocolFactory).marshall((UpdateEnrollmentStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateEnrollmentStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Compute Optimizer");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateEnrollmentStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEnrollmentStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEnrollmentStatusResult updateEnrollmentStatusResult = (UpdateEnrollmentStatusResult)response.getAwsResponse();
            return updateEnrollmentStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

