/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * AWS Compute Optimizer is a service that analyzes the configuration and utilization metrics of your AWS compute
 * resources, such as EC2 instances, Auto Scaling groups, AWS Lambda functions, and Amazon EBS volumes. It reports
 * whether your resources are optimal, and generates optimization recommendations to reduce the cost and improve the
 * performance of your workloads. Compute Optimizer also provides recent utilization metric data, as well as projected
 * utilization metric data for the recommendations, which you can use to evaluate which recommendation provides the best
 * price-performance trade-off. The analysis of your usage patterns can help you decide when to move or resize your
 * running resources, and still meet your performance and capacity requirements. For more information about Compute
 * Optimizer, including the required permissions to use the service, see the <a
 * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/">AWS Compute Optimizer User Guide</a>.
 * </p>
 */
package com.amazonaws.services.computeoptimizer;

