/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.ExtractedCharactersListItem;
import com.amazonaws.services.comprehend.model.transform.DocumentMetadataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DocumentMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer pages;
    private List<ExtractedCharactersListItem> extractedCharacters;

    public void setPages(Integer pages) {
        this.pages = pages;
    }

    public Integer getPages() {
        return this.pages;
    }

    public DocumentMetadata withPages(Integer pages) {
        this.setPages(pages);
        return this;
    }

    public List<ExtractedCharactersListItem> getExtractedCharacters() {
        return this.extractedCharacters;
    }

    public void setExtractedCharacters(Collection<ExtractedCharactersListItem> extractedCharacters) {
        if (extractedCharacters == null) {
            this.extractedCharacters = null;
            return;
        }
        this.extractedCharacters = new ArrayList<ExtractedCharactersListItem>(extractedCharacters);
    }

    public DocumentMetadata withExtractedCharacters(ExtractedCharactersListItem ... extractedCharacters) {
        if (this.extractedCharacters == null) {
            this.setExtractedCharacters(new ArrayList<ExtractedCharactersListItem>(extractedCharacters.length));
        }
        for (ExtractedCharactersListItem ele : extractedCharacters) {
            this.extractedCharacters.add(ele);
        }
        return this;
    }

    public DocumentMetadata withExtractedCharacters(Collection<ExtractedCharactersListItem> extractedCharacters) {
        this.setExtractedCharacters(extractedCharacters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPages() != null) {
            sb.append("Pages: ").append(this.getPages()).append(",");
        }
        if (this.getExtractedCharacters() != null) {
            sb.append("ExtractedCharacters: ").append(this.getExtractedCharacters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata other = (DocumentMetadata)obj;
        if (other.getPages() == null ^ this.getPages() == null) {
            return false;
        }
        if (other.getPages() != null && !other.getPages().equals(this.getPages())) {
            return false;
        }
        if (other.getExtractedCharacters() == null ^ this.getExtractedCharacters() == null) {
            return false;
        }
        return other.getExtractedCharacters() == null || other.getExtractedCharacters().equals(this.getExtractedCharacters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPages() == null ? 0 : this.getPages().hashCode());
        hashCode = 31 * hashCode + (this.getExtractedCharacters() == null ? 0 : this.getExtractedCharacters().hashCode());
        return hashCode;
    }

    public DocumentMetadata clone() {
        try {
            return (DocumentMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

