/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncAsync;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncClient;
import com.amazonaws.services.cognitosync.model.BulkPublishRequest;
import com.amazonaws.services.cognitosync.model.BulkPublishResult;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.services.cognitosync.model.DeleteDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeDatasetRequest;
import com.amazonaws.services.cognitosync.model.DescribeDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageResult;
import com.amazonaws.services.cognitosync.model.GetBulkPublishDetailsRequest;
import com.amazonaws.services.cognitosync.model.GetBulkPublishDetailsResult;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.services.cognitosync.model.ListDatasetsResult;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.services.cognitosync.model.ListRecordsResult;
import com.amazonaws.services.cognitosync.model.RegisterDeviceRequest;
import com.amazonaws.services.cognitosync.model.RegisterDeviceResult;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetRequest;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetResult;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetResult;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.services.cognitosync.model.UpdateRecordsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonCognitoSyncAsyncClient
extends AmazonCognitoSyncClient
implements AmazonCognitoSyncAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonCognitoSyncAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCognitoSyncAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCognitoSyncAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<UpdateRecordsResult> updateRecordsAsync(final UpdateRecordsRequest updateRecordsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateRecordsResult>(){

            @Override
            public UpdateRecordsResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.updateRecords(updateRecordsRequest);
            }
        });
    }

    @Override
    public Future<UpdateRecordsResult> updateRecordsAsync(final UpdateRecordsRequest updateRecordsRequest, final AsyncHandler<UpdateRecordsRequest, UpdateRecordsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateRecordsResult>(){

            @Override
            public UpdateRecordsResult call() throws Exception {
                UpdateRecordsResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.updateRecords(updateRecordsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateRecordsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityUsageResult> describeIdentityUsageAsync(final DescribeIdentityUsageRequest describeIdentityUsageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityUsageResult>(){

            @Override
            public DescribeIdentityUsageResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.describeIdentityUsage(describeIdentityUsageRequest);
            }
        });
    }

    @Override
    public Future<DescribeIdentityUsageResult> describeIdentityUsageAsync(final DescribeIdentityUsageRequest describeIdentityUsageRequest, final AsyncHandler<DescribeIdentityUsageRequest, DescribeIdentityUsageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityUsageResult>(){

            @Override
            public DescribeIdentityUsageResult call() throws Exception {
                DescribeIdentityUsageResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.describeIdentityUsage(describeIdentityUsageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeIdentityUsageRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UnsubscribeFromDatasetResult> unsubscribeFromDatasetAsync(final UnsubscribeFromDatasetRequest unsubscribeFromDatasetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UnsubscribeFromDatasetResult>(){

            @Override
            public UnsubscribeFromDatasetResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.unsubscribeFromDataset(unsubscribeFromDatasetRequest);
            }
        });
    }

    @Override
    public Future<UnsubscribeFromDatasetResult> unsubscribeFromDatasetAsync(final UnsubscribeFromDatasetRequest unsubscribeFromDatasetRequest, final AsyncHandler<UnsubscribeFromDatasetRequest, UnsubscribeFromDatasetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UnsubscribeFromDatasetResult>(){

            @Override
            public UnsubscribeFromDatasetResult call() throws Exception {
                UnsubscribeFromDatasetResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.unsubscribeFromDataset(unsubscribeFromDatasetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)unsubscribeFromDatasetRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<SetIdentityPoolConfigurationResult> setIdentityPoolConfigurationAsync(final SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SetIdentityPoolConfigurationResult>(){

            @Override
            public SetIdentityPoolConfigurationResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.setIdentityPoolConfiguration(setIdentityPoolConfigurationRequest);
            }
        });
    }

    @Override
    public Future<SetIdentityPoolConfigurationResult> setIdentityPoolConfigurationAsync(final SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest, final AsyncHandler<SetIdentityPoolConfigurationRequest, SetIdentityPoolConfigurationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SetIdentityPoolConfigurationResult>(){

            @Override
            public SetIdentityPoolConfigurationResult call() throws Exception {
                SetIdentityPoolConfigurationResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.setIdentityPoolConfiguration(setIdentityPoolConfigurationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)setIdentityPoolConfigurationRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetIdentityPoolConfigurationResult> getIdentityPoolConfigurationAsync(final GetIdentityPoolConfigurationRequest getIdentityPoolConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetIdentityPoolConfigurationResult>(){

            @Override
            public GetIdentityPoolConfigurationResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.getIdentityPoolConfiguration(getIdentityPoolConfigurationRequest);
            }
        });
    }

    @Override
    public Future<GetIdentityPoolConfigurationResult> getIdentityPoolConfigurationAsync(final GetIdentityPoolConfigurationRequest getIdentityPoolConfigurationRequest, final AsyncHandler<GetIdentityPoolConfigurationRequest, GetIdentityPoolConfigurationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetIdentityPoolConfigurationResult>(){

            @Override
            public GetIdentityPoolConfigurationResult call() throws Exception {
                GetIdentityPoolConfigurationResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.getIdentityPoolConfiguration(getIdentityPoolConfigurationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getIdentityPoolConfigurationRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<SubscribeToDatasetResult> subscribeToDatasetAsync(final SubscribeToDatasetRequest subscribeToDatasetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SubscribeToDatasetResult>(){

            @Override
            public SubscribeToDatasetResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.subscribeToDataset(subscribeToDatasetRequest);
            }
        });
    }

    @Override
    public Future<SubscribeToDatasetResult> subscribeToDatasetAsync(final SubscribeToDatasetRequest subscribeToDatasetRequest, final AsyncHandler<SubscribeToDatasetRequest, SubscribeToDatasetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SubscribeToDatasetResult>(){

            @Override
            public SubscribeToDatasetResult call() throws Exception {
                SubscribeToDatasetResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.subscribeToDataset(subscribeToDatasetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)subscribeToDatasetRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityPoolUsageResult> describeIdentityPoolUsageAsync(final DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityPoolUsageResult>(){

            @Override
            public DescribeIdentityPoolUsageResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.describeIdentityPoolUsage(describeIdentityPoolUsageRequest);
            }
        });
    }

    @Override
    public Future<DescribeIdentityPoolUsageResult> describeIdentityPoolUsageAsync(final DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest, final AsyncHandler<DescribeIdentityPoolUsageRequest, DescribeIdentityPoolUsageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeIdentityPoolUsageResult>(){

            @Override
            public DescribeIdentityPoolUsageResult call() throws Exception {
                DescribeIdentityPoolUsageResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.describeIdentityPoolUsage(describeIdentityPoolUsageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeIdentityPoolUsageRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(final ListDatasetsRequest listDatasetsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDatasetsResult>(){

            @Override
            public ListDatasetsResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.listDatasets(listDatasetsRequest);
            }
        });
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(final ListDatasetsRequest listDatasetsRequest, final AsyncHandler<ListDatasetsRequest, ListDatasetsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDatasetsResult>(){

            @Override
            public ListDatasetsResult call() throws Exception {
                ListDatasetsResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.listDatasets(listDatasetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listDatasetsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListIdentityPoolUsageResult> listIdentityPoolUsageAsync(final ListIdentityPoolUsageRequest listIdentityPoolUsageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListIdentityPoolUsageResult>(){

            @Override
            public ListIdentityPoolUsageResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.listIdentityPoolUsage(listIdentityPoolUsageRequest);
            }
        });
    }

    @Override
    public Future<ListIdentityPoolUsageResult> listIdentityPoolUsageAsync(final ListIdentityPoolUsageRequest listIdentityPoolUsageRequest, final AsyncHandler<ListIdentityPoolUsageRequest, ListIdentityPoolUsageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListIdentityPoolUsageResult>(){

            @Override
            public ListIdentityPoolUsageResult call() throws Exception {
                ListIdentityPoolUsageResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.listIdentityPoolUsage(listIdentityPoolUsageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listIdentityPoolUsageRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListRecordsResult> listRecordsAsync(final ListRecordsRequest listRecordsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListRecordsResult>(){

            @Override
            public ListRecordsResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.listRecords(listRecordsRequest);
            }
        });
    }

    @Override
    public Future<ListRecordsResult> listRecordsAsync(final ListRecordsRequest listRecordsRequest, final AsyncHandler<ListRecordsRequest, ListRecordsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListRecordsResult>(){

            @Override
            public ListRecordsResult call() throws Exception {
                ListRecordsResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.listRecords(listRecordsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listRecordsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetBulkPublishDetailsResult> getBulkPublishDetailsAsync(final GetBulkPublishDetailsRequest getBulkPublishDetailsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetBulkPublishDetailsResult>(){

            @Override
            public GetBulkPublishDetailsResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.getBulkPublishDetails(getBulkPublishDetailsRequest);
            }
        });
    }

    @Override
    public Future<GetBulkPublishDetailsResult> getBulkPublishDetailsAsync(final GetBulkPublishDetailsRequest getBulkPublishDetailsRequest, final AsyncHandler<GetBulkPublishDetailsRequest, GetBulkPublishDetailsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetBulkPublishDetailsResult>(){

            @Override
            public GetBulkPublishDetailsResult call() throws Exception {
                GetBulkPublishDetailsResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.getBulkPublishDetails(getBulkPublishDetailsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getBulkPublishDetailsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<BulkPublishResult> bulkPublishAsync(final BulkPublishRequest bulkPublishRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BulkPublishResult>(){

            @Override
            public BulkPublishResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.bulkPublish(bulkPublishRequest);
            }
        });
    }

    @Override
    public Future<BulkPublishResult> bulkPublishAsync(final BulkPublishRequest bulkPublishRequest, final AsyncHandler<BulkPublishRequest, BulkPublishResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<BulkPublishResult>(){

            @Override
            public BulkPublishResult call() throws Exception {
                BulkPublishResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.bulkPublish(bulkPublishRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)bulkPublishRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(final DescribeDatasetRequest describeDatasetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDatasetResult>(){

            @Override
            public DescribeDatasetResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.describeDataset(describeDatasetRequest);
            }
        });
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(final DescribeDatasetRequest describeDatasetRequest, final AsyncHandler<DescribeDatasetRequest, DescribeDatasetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDatasetResult>(){

            @Override
            public DescribeDatasetResult call() throws Exception {
                DescribeDatasetResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.describeDataset(describeDatasetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeDatasetRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(final DeleteDatasetRequest deleteDatasetRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDatasetResult>(){

            @Override
            public DeleteDatasetResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.deleteDataset(deleteDatasetRequest);
            }
        });
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(final DeleteDatasetRequest deleteDatasetRequest, final AsyncHandler<DeleteDatasetRequest, DeleteDatasetResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDatasetResult>(){

            @Override
            public DeleteDatasetResult call() throws Exception {
                DeleteDatasetResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.deleteDataset(deleteDatasetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteDatasetRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<RegisterDeviceResult> registerDeviceAsync(final RegisterDeviceRequest registerDeviceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterDeviceResult>(){

            @Override
            public RegisterDeviceResult call() throws Exception {
                return AmazonCognitoSyncAsyncClient.this.registerDevice(registerDeviceRequest);
            }
        });
    }

    @Override
    public Future<RegisterDeviceResult> registerDeviceAsync(final RegisterDeviceRequest registerDeviceRequest, final AsyncHandler<RegisterDeviceRequest, RegisterDeviceResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<RegisterDeviceResult>(){

            @Override
            public RegisterDeviceResult call() throws Exception {
                RegisterDeviceResult result;
                try {
                    result = AmazonCognitoSyncAsyncClient.this.registerDevice(registerDeviceRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)registerDeviceRequest, (Object)result);
                return result;
            }
        });
    }
}

