/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitosync.model.RecordPatch;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UpdateRecordsRequestMarshaller
implements Marshaller<Request<UpdateRecordsRequest>, UpdateRecordsRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<UpdateRecordsRequest> marshall(UpdateRecordsRequest updateRecordsRequest) {
        String value;
        String name;
        if (updateRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateRecordsRequest, "AmazonCognitoSync");
        String target = "AWSCognitoSyncService.UpdateRecords";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        if (updateRecordsRequest.getClientContext() != null) {
            request.addHeader("x-amz-Client-Context", StringUtils.fromString((String)updateRecordsRequest.getClientContext()));
        }
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("IdentityPoolId")) {
            name = DYNAMIC_QUERY_PARAMS.get("IdentityPoolId");
            String string = value = updateRecordsRequest.getIdentityPoolId() == null ? null : StringUtils.fromString((String)updateRecordsRequest.getIdentityPoolId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", updateRecordsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)updateRecordsRequest.getIdentityPoolId()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("IdentityId")) {
            name = DYNAMIC_QUERY_PARAMS.get("IdentityId");
            String string = value = updateRecordsRequest.getIdentityId() == null ? null : StringUtils.fromString((String)updateRecordsRequest.getIdentityId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{IdentityId}", updateRecordsRequest.getIdentityId() == null ? "" : StringUtils.fromString((String)updateRecordsRequest.getIdentityId()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("DatasetName")) {
            name = DYNAMIC_QUERY_PARAMS.get("DatasetName");
            String string = value = updateRecordsRequest.getDatasetName() == null ? null : StringUtils.fromString((String)updateRecordsRequest.getDatasetName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{DatasetName}", updateRecordsRequest.getDatasetName() == null ? "" : StringUtils.fromString((String)updateRecordsRequest.getDatasetName()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag recordPatchesList = (ListWithAutoConstructFlag)updateRecordsRequest.getRecordPatches();
            if (!(recordPatchesList == null || recordPatchesList.isAutoConstruct() && recordPatchesList.isEmpty())) {
                jsonWriter.key("RecordPatches");
                jsonWriter.array();
                for (RecordPatch recordPatchesListValue : recordPatchesList) {
                    if (recordPatchesListValue == null) continue;
                    jsonWriter.object();
                    if (recordPatchesListValue.getOp() != null) {
                        jsonWriter.key("Op").value((Object)recordPatchesListValue.getOp());
                    }
                    if (recordPatchesListValue.getKey() != null) {
                        jsonWriter.key("Key").value((Object)recordPatchesListValue.getKey());
                    }
                    if (recordPatchesListValue.getValue() != null) {
                        jsonWriter.key("Value").value((Object)recordPatchesListValue.getValue());
                    }
                    if (recordPatchesListValue.getSyncCount() != null) {
                        jsonWriter.key("SyncCount").value((Object)recordPatchesListValue.getSyncCount());
                    }
                    if (recordPatchesListValue.getDeviceLastModifiedDate() != null) {
                        jsonWriter.key("DeviceLastModifiedDate").value(recordPatchesListValue.getDeviceLastModifiedDate());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (updateRecordsRequest.getSyncSessionToken() != null) {
                jsonWriter.key("SyncSessionToken").value((Object)updateRecordsRequest.getSyncSessionToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    static {
        String path = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

