/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cognitosync.model.Record;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListRecordsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Record> records;
    private String nextToken;
    private Integer count;
    private Long datasetSyncCount;
    private String lastModifiedBy;
    private SdkInternalList<String> mergedDatasetNames;
    private Boolean datasetExists;
    private Boolean datasetDeletedAfterRequestedSyncCount;
    private String syncSessionToken;

    public List<Record> getRecords() {
        if (this.records == null) {
            this.records = new SdkInternalList();
        }
        return this.records;
    }

    public void setRecords(Collection<Record> records) {
        if (records == null) {
            this.records = null;
            return;
        }
        this.records = new SdkInternalList(records);
    }

    public ListRecordsResult withRecords(Record ... records) {
        if (this.records == null) {
            this.setRecords((Collection<Record>)new SdkInternalList(records.length));
        }
        for (Record ele : records) {
            this.records.add((Object)ele);
        }
        return this;
    }

    public ListRecordsResult withRecords(Collection<Record> records) {
        this.setRecords(records);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRecordsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getCount() {
        return this.count;
    }

    public ListRecordsResult withCount(Integer count) {
        this.setCount(count);
        return this;
    }

    public void setDatasetSyncCount(Long datasetSyncCount) {
        this.datasetSyncCount = datasetSyncCount;
    }

    public Long getDatasetSyncCount() {
        return this.datasetSyncCount;
    }

    public ListRecordsResult withDatasetSyncCount(Long datasetSyncCount) {
        this.setDatasetSyncCount(datasetSyncCount);
        return this;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public ListRecordsResult withLastModifiedBy(String lastModifiedBy) {
        this.setLastModifiedBy(lastModifiedBy);
        return this;
    }

    public List<String> getMergedDatasetNames() {
        if (this.mergedDatasetNames == null) {
            this.mergedDatasetNames = new SdkInternalList();
        }
        return this.mergedDatasetNames;
    }

    public void setMergedDatasetNames(Collection<String> mergedDatasetNames) {
        if (mergedDatasetNames == null) {
            this.mergedDatasetNames = null;
            return;
        }
        this.mergedDatasetNames = new SdkInternalList(mergedDatasetNames);
    }

    public ListRecordsResult withMergedDatasetNames(String ... mergedDatasetNames) {
        if (this.mergedDatasetNames == null) {
            this.setMergedDatasetNames((Collection<String>)new SdkInternalList(mergedDatasetNames.length));
        }
        for (String ele : mergedDatasetNames) {
            this.mergedDatasetNames.add((Object)ele);
        }
        return this;
    }

    public ListRecordsResult withMergedDatasetNames(Collection<String> mergedDatasetNames) {
        this.setMergedDatasetNames(mergedDatasetNames);
        return this;
    }

    public void setDatasetExists(Boolean datasetExists) {
        this.datasetExists = datasetExists;
    }

    public Boolean getDatasetExists() {
        return this.datasetExists;
    }

    public ListRecordsResult withDatasetExists(Boolean datasetExists) {
        this.setDatasetExists(datasetExists);
        return this;
    }

    public Boolean isDatasetExists() {
        return this.datasetExists;
    }

    public void setDatasetDeletedAfterRequestedSyncCount(Boolean datasetDeletedAfterRequestedSyncCount) {
        this.datasetDeletedAfterRequestedSyncCount = datasetDeletedAfterRequestedSyncCount;
    }

    public Boolean getDatasetDeletedAfterRequestedSyncCount() {
        return this.datasetDeletedAfterRequestedSyncCount;
    }

    public ListRecordsResult withDatasetDeletedAfterRequestedSyncCount(Boolean datasetDeletedAfterRequestedSyncCount) {
        this.setDatasetDeletedAfterRequestedSyncCount(datasetDeletedAfterRequestedSyncCount);
        return this;
    }

    public Boolean isDatasetDeletedAfterRequestedSyncCount() {
        return this.datasetDeletedAfterRequestedSyncCount;
    }

    public void setSyncSessionToken(String syncSessionToken) {
        this.syncSessionToken = syncSessionToken;
    }

    public String getSyncSessionToken() {
        return this.syncSessionToken;
    }

    public ListRecordsResult withSyncSessionToken(String syncSessionToken) {
        this.setSyncSessionToken(syncSessionToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecords() != null) {
            sb.append("Records: ").append(this.getRecords()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getCount() != null) {
            sb.append("Count: ").append(this.getCount()).append(",");
        }
        if (this.getDatasetSyncCount() != null) {
            sb.append("DatasetSyncCount: ").append(this.getDatasetSyncCount()).append(",");
        }
        if (this.getLastModifiedBy() != null) {
            sb.append("LastModifiedBy: ").append(this.getLastModifiedBy()).append(",");
        }
        if (this.getMergedDatasetNames() != null) {
            sb.append("MergedDatasetNames: ").append(this.getMergedDatasetNames()).append(",");
        }
        if (this.getDatasetExists() != null) {
            sb.append("DatasetExists: ").append(this.getDatasetExists()).append(",");
        }
        if (this.getDatasetDeletedAfterRequestedSyncCount() != null) {
            sb.append("DatasetDeletedAfterRequestedSyncCount: ").append(this.getDatasetDeletedAfterRequestedSyncCount()).append(",");
        }
        if (this.getSyncSessionToken() != null) {
            sb.append("SyncSessionToken: ").append(this.getSyncSessionToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordsResult)) {
            return false;
        }
        ListRecordsResult other = (ListRecordsResult)obj;
        if (other.getRecords() == null ^ this.getRecords() == null) {
            return false;
        }
        if (other.getRecords() != null && !other.getRecords().equals(this.getRecords())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (other.getCount() != null && !other.getCount().equals(this.getCount())) {
            return false;
        }
        if (other.getDatasetSyncCount() == null ^ this.getDatasetSyncCount() == null) {
            return false;
        }
        if (other.getDatasetSyncCount() != null && !other.getDatasetSyncCount().equals(this.getDatasetSyncCount())) {
            return false;
        }
        if (other.getLastModifiedBy() == null ^ this.getLastModifiedBy() == null) {
            return false;
        }
        if (other.getLastModifiedBy() != null && !other.getLastModifiedBy().equals(this.getLastModifiedBy())) {
            return false;
        }
        if (other.getMergedDatasetNames() == null ^ this.getMergedDatasetNames() == null) {
            return false;
        }
        if (other.getMergedDatasetNames() != null && !other.getMergedDatasetNames().equals(this.getMergedDatasetNames())) {
            return false;
        }
        if (other.getDatasetExists() == null ^ this.getDatasetExists() == null) {
            return false;
        }
        if (other.getDatasetExists() != null && !other.getDatasetExists().equals(this.getDatasetExists())) {
            return false;
        }
        if (other.getDatasetDeletedAfterRequestedSyncCount() == null ^ this.getDatasetDeletedAfterRequestedSyncCount() == null) {
            return false;
        }
        if (other.getDatasetDeletedAfterRequestedSyncCount() != null && !other.getDatasetDeletedAfterRequestedSyncCount().equals(this.getDatasetDeletedAfterRequestedSyncCount())) {
            return false;
        }
        if (other.getSyncSessionToken() == null ^ this.getSyncSessionToken() == null) {
            return false;
        }
        return other.getSyncSessionToken() == null || other.getSyncSessionToken().equals(this.getSyncSessionToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecords() == null ? 0 : this.getRecords().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getCount() == null ? 0 : this.getCount().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetSyncCount() == null ? 0 : this.getDatasetSyncCount().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        hashCode = 31 * hashCode + (this.getMergedDatasetNames() == null ? 0 : this.getMergedDatasetNames().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetExists() == null ? 0 : this.getDatasetExists().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetDeletedAfterRequestedSyncCount() == null ? 0 : this.getDatasetDeletedAfterRequestedSyncCount().hashCode());
        hashCode = 31 * hashCode + (this.getSyncSessionToken() == null ? 0 : this.getSyncSessionToken().hashCode());
        return hashCode;
    }

    public ListRecordsResult clone() {
        try {
            return (ListRecordsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

