/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SubscribeToDatasetRequestMarshaller
implements Marshaller<Request<SubscribeToDatasetRequest>, SubscribeToDatasetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SubscribeToDatasetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SubscribeToDatasetRequest> marshall(SubscribeToDatasetRequest subscribeToDatasetRequest) {
        if (subscribeToDatasetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)subscribeToDatasetRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "IdentityPoolId", subscribeToDatasetRequest.getIdentityPoolId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "IdentityId", subscribeToDatasetRequest.getIdentityId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "DatasetName", subscribeToDatasetRequest.getDatasetName());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "DeviceId", subscribeToDatasetRequest.getDeviceId());
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

