/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.cognitosync.model.SetCognitoEventsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class SetCognitoEventsRequestMarshaller
implements Marshaller<Request<SetCognitoEventsRequest>, SetCognitoEventsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";

    public Request<SetCognitoEventsRequest> marshall(SetCognitoEventsRequest setCognitoEventsRequest) {
        if (setCognitoEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setCognitoEventsRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/events";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", setCognitoEventsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString((String)setCognitoEventsRequest.getIdentityPoolId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            SdkInternalMap eventsMap = (SdkInternalMap)setCognitoEventsRequest.getEvents();
            if (!eventsMap.isEmpty() || !eventsMap.isAutoConstruct()) {
                jsonWriter.key("Events");
                jsonWriter.object();
                for (Map.Entry eventsMapValue : eventsMap.entrySet()) {
                    if (eventsMapValue.getValue() == null) continue;
                    jsonWriter.key((String)eventsMapValue.getKey());
                    jsonWriter.value(eventsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

