/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cognitoidp.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The SMS text message multi-factor authentication (MFA) configuration type.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SmsMfaConfigType" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SmsMfaConfigType implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The SMS authentication message that will be sent to users with the code they must sign in. The message must
     * contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn't included, and default
     * message will be used.
     * </p>
     */
    private String smsAuthenticationMessage;
    /**
     * <p>
     * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from
     * your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in the Amazon
     * Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role
     * that you provide for your Amazon Web Services account.
     * </p>
     */
    private SmsConfigurationType smsConfiguration;

    /**
     * <p>
     * The SMS authentication message that will be sent to users with the code they must sign in. The message must
     * contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn't included, and default
     * message will be used.
     * </p>
     * 
     * @param smsAuthenticationMessage
     *        The SMS authentication message that will be sent to users with the code they must sign in. The message
     *        must contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn't included, and
     *        default message will be used.
     */

    public void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
        this.smsAuthenticationMessage = smsAuthenticationMessage;
    }

    /**
     * <p>
     * The SMS authentication message that will be sent to users with the code they must sign in. The message must
     * contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn't included, and default
     * message will be used.
     * </p>
     * 
     * @return The SMS authentication message that will be sent to users with the code they must sign in. The message
     *         must contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn't included,
     *         and default message will be used.
     */

    public String getSmsAuthenticationMessage() {
        return this.smsAuthenticationMessage;
    }

    /**
     * <p>
     * The SMS authentication message that will be sent to users with the code they must sign in. The message must
     * contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn't included, and default
     * message will be used.
     * </p>
     * 
     * @param smsAuthenticationMessage
     *        The SMS authentication message that will be sent to users with the code they must sign in. The message
     *        must contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn't included, and
     *        default message will be used.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SmsMfaConfigType withSmsAuthenticationMessage(String smsAuthenticationMessage) {
        setSmsAuthenticationMessage(smsAuthenticationMessage);
        return this;
    }

    /**
     * <p>
     * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from
     * your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in the Amazon
     * Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role
     * that you provide for your Amazon Web Services account.
     * </p>
     * 
     * @param smsConfiguration
     *        The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message
     *        from your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in
     *        the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access
     *        Management (IAM) role that you provide for your Amazon Web Services account.
     */

    public void setSmsConfiguration(SmsConfigurationType smsConfiguration) {
        this.smsConfiguration = smsConfiguration;
    }

    /**
     * <p>
     * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from
     * your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in the Amazon
     * Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role
     * that you provide for your Amazon Web Services account.
     * </p>
     * 
     * @return The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS
     *         message from your Amazon Web Services account through Amazon Simple Notification Service. To request
     *         Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity
     *         and Access Management (IAM) role that you provide for your Amazon Web Services account.
     */

    public SmsConfigurationType getSmsConfiguration() {
        return this.smsConfiguration;
    }

    /**
     * <p>
     * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from
     * your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in the Amazon
     * Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role
     * that you provide for your Amazon Web Services account.
     * </p>
     * 
     * @param smsConfiguration
     *        The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message
     *        from your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in
     *        the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access
     *        Management (IAM) role that you provide for your Amazon Web Services account.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SmsMfaConfigType withSmsConfiguration(SmsConfigurationType smsConfiguration) {
        setSmsConfiguration(smsConfiguration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSmsAuthenticationMessage() != null)
            sb.append("SmsAuthenticationMessage: ").append(getSmsAuthenticationMessage()).append(",");
        if (getSmsConfiguration() != null)
            sb.append("SmsConfiguration: ").append(getSmsConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SmsMfaConfigType == false)
            return false;
        SmsMfaConfigType other = (SmsMfaConfigType) obj;
        if (other.getSmsAuthenticationMessage() == null ^ this.getSmsAuthenticationMessage() == null)
            return false;
        if (other.getSmsAuthenticationMessage() != null && other.getSmsAuthenticationMessage().equals(this.getSmsAuthenticationMessage()) == false)
            return false;
        if (other.getSmsConfiguration() == null ^ this.getSmsConfiguration() == null)
            return false;
        if (other.getSmsConfiguration() != null && other.getSmsConfiguration().equals(this.getSmsConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSmsAuthenticationMessage() == null) ? 0 : getSmsAuthenticationMessage().hashCode());
        hashCode = prime * hashCode + ((getSmsConfiguration() == null) ? 0 : getSmsConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public SmsMfaConfigType clone() {
        try {
            return (SmsMfaConfigType) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.cognitoidp.model.transform.SmsMfaConfigTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
