/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cognitoidp.model.ResourceServerScopeType;
import com.amazonaws.services.cognitoidp.model.transform.ResourceServerTypeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResourceServerType
implements Serializable,
Cloneable,
StructuredPojo {
    private String userPoolId;
    private String identifier;
    private String name;
    private List<ResourceServerScopeType> scopes;

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public ResourceServerType withUserPoolId(String userPoolId) {
        this.setUserPoolId(userPoolId);
        return this;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ResourceServerType withIdentifier(String identifier) {
        this.setIdentifier(identifier);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ResourceServerType withName(String name) {
        this.setName(name);
        return this;
    }

    public List<ResourceServerScopeType> getScopes() {
        return this.scopes;
    }

    public void setScopes(Collection<ResourceServerScopeType> scopes) {
        if (scopes == null) {
            this.scopes = null;
            return;
        }
        this.scopes = new ArrayList<ResourceServerScopeType>(scopes);
    }

    public ResourceServerType withScopes(ResourceServerScopeType ... scopes) {
        if (this.scopes == null) {
            this.setScopes(new ArrayList<ResourceServerScopeType>(scopes.length));
        }
        for (ResourceServerScopeType ele : scopes) {
            this.scopes.add(ele);
        }
        return this;
    }

    public ResourceServerType withScopes(Collection<ResourceServerScopeType> scopes) {
        this.setScopes(scopes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolId() != null) {
            sb.append("UserPoolId: ").append(this.getUserPoolId()).append(",");
        }
        if (this.getIdentifier() != null) {
            sb.append("Identifier: ").append(this.getIdentifier()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getScopes() != null) {
            sb.append("Scopes: ").append(this.getScopes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceServerType)) {
            return false;
        }
        ResourceServerType other = (ResourceServerType)obj;
        if (other.getUserPoolId() == null ^ this.getUserPoolId() == null) {
            return false;
        }
        if (other.getUserPoolId() != null && !other.getUserPoolId().equals(this.getUserPoolId())) {
            return false;
        }
        if (other.getIdentifier() == null ^ this.getIdentifier() == null) {
            return false;
        }
        if (other.getIdentifier() != null && !other.getIdentifier().equals(this.getIdentifier())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getScopes() == null ^ this.getScopes() == null) {
            return false;
        }
        return other.getScopes() == null || other.getScopes().equals(this.getScopes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolId() == null ? 0 : this.getUserPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getScopes() == null ? 0 : this.getScopes().hashCode());
        return hashCode;
    }

    public ResourceServerType clone() {
        try {
            return (ResourceServerType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceServerTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

