/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.ConfirmDeviceRequest;
import com.amazonaws.services.cognitoidp.model.transform.DeviceSecretVerifierConfigTypeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ConfirmDeviceRequestMarshaller
implements Marshaller<Request<ConfirmDeviceRequest>, ConfirmDeviceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ConfirmDeviceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ConfirmDeviceRequest> marshall(ConfirmDeviceRequest confirmDeviceRequest) {
        if (confirmDeviceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)confirmDeviceRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.ConfirmDevice");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (confirmDeviceRequest.getAccessToken() != null) {
                jsonGenerator.writeFieldName("AccessToken").writeValue(confirmDeviceRequest.getAccessToken());
            }
            if (confirmDeviceRequest.getDeviceKey() != null) {
                jsonGenerator.writeFieldName("DeviceKey").writeValue(confirmDeviceRequest.getDeviceKey());
            }
            if (confirmDeviceRequest.getDeviceSecretVerifierConfig() != null) {
                jsonGenerator.writeFieldName("DeviceSecretVerifierConfig");
                DeviceSecretVerifierConfigTypeJsonMarshaller.getInstance().marshall(confirmDeviceRequest.getDeviceSecretVerifierConfig(), jsonGenerator);
            }
            if (confirmDeviceRequest.getDeviceName() != null) {
                jsonGenerator.writeFieldName("DeviceName").writeValue(confirmDeviceRequest.getDeviceName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

