/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateIdentityPoolRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String identityPoolId;
    private String identityPoolName;
    private Boolean allowUnauthenticatedIdentities;
    private Map<String, String> supportedLoginProviders;
    private String developerProviderName;
    private ListWithAutoConstructFlag<String> openIdConnectProviderARNs;

    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public void setIdentityPoolId(String identityPoolId) {
        this.identityPoolId = identityPoolId;
    }

    public UpdateIdentityPoolRequest withIdentityPoolId(String identityPoolId) {
        this.identityPoolId = identityPoolId;
        return this;
    }

    public String getIdentityPoolName() {
        return this.identityPoolName;
    }

    public void setIdentityPoolName(String identityPoolName) {
        this.identityPoolName = identityPoolName;
    }

    public UpdateIdentityPoolRequest withIdentityPoolName(String identityPoolName) {
        this.identityPoolName = identityPoolName;
        return this;
    }

    public Boolean isAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public void setAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
        this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
    }

    public UpdateIdentityPoolRequest withAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
        this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
        return this;
    }

    public Boolean getAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public Map<String, String> getSupportedLoginProviders() {
        return this.supportedLoginProviders;
    }

    public void setSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
        this.supportedLoginProviders = supportedLoginProviders;
    }

    public UpdateIdentityPoolRequest withSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
        this.setSupportedLoginProviders(supportedLoginProviders);
        return this;
    }

    public UpdateIdentityPoolRequest addSupportedLoginProvidersEntry(String key, String value) {
        if (null == this.supportedLoginProviders) {
            this.supportedLoginProviders = new HashMap<String, String>();
        }
        if (this.supportedLoginProviders.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.supportedLoginProviders.put(key, value);
        return this;
    }

    public UpdateIdentityPoolRequest clearSupportedLoginProvidersEntries() {
        this.supportedLoginProviders = null;
        return this;
    }

    public String getDeveloperProviderName() {
        return this.developerProviderName;
    }

    public void setDeveloperProviderName(String developerProviderName) {
        this.developerProviderName = developerProviderName;
    }

    public UpdateIdentityPoolRequest withDeveloperProviderName(String developerProviderName) {
        this.developerProviderName = developerProviderName;
        return this;
    }

    public List<String> getOpenIdConnectProviderARNs() {
        return this.openIdConnectProviderARNs;
    }

    public void setOpenIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
        if (openIdConnectProviderARNs == null) {
            this.openIdConnectProviderARNs = null;
            return;
        }
        ListWithAutoConstructFlag openIdConnectProviderARNsCopy = new ListWithAutoConstructFlag(openIdConnectProviderARNs.size());
        openIdConnectProviderARNsCopy.addAll(openIdConnectProviderARNs);
        this.openIdConnectProviderARNs = openIdConnectProviderARNsCopy;
    }

    public UpdateIdentityPoolRequest withOpenIdConnectProviderARNs(String ... openIdConnectProviderARNs) {
        if (this.getOpenIdConnectProviderARNs() == null) {
            this.setOpenIdConnectProviderARNs(new ArrayList<String>(openIdConnectProviderARNs.length));
        }
        for (String value : openIdConnectProviderARNs) {
            this.getOpenIdConnectProviderARNs().add(value);
        }
        return this;
    }

    public UpdateIdentityPoolRequest withOpenIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
        if (openIdConnectProviderARNs == null) {
            this.openIdConnectProviderARNs = null;
        } else {
            ListWithAutoConstructFlag openIdConnectProviderARNsCopy = new ListWithAutoConstructFlag(openIdConnectProviderARNs.size());
            openIdConnectProviderARNsCopy.addAll(openIdConnectProviderARNs);
            this.openIdConnectProviderARNs = openIdConnectProviderARNsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityPoolId() != null) {
            sb.append("IdentityPoolId: " + this.getIdentityPoolId() + ",");
        }
        if (this.getIdentityPoolName() != null) {
            sb.append("IdentityPoolName: " + this.getIdentityPoolName() + ",");
        }
        if (this.isAllowUnauthenticatedIdentities() != null) {
            sb.append("AllowUnauthenticatedIdentities: " + this.isAllowUnauthenticatedIdentities() + ",");
        }
        if (this.getSupportedLoginProviders() != null) {
            sb.append("SupportedLoginProviders: " + this.getSupportedLoginProviders() + ",");
        }
        if (this.getDeveloperProviderName() != null) {
            sb.append("DeveloperProviderName: " + this.getDeveloperProviderName() + ",");
        }
        if (this.getOpenIdConnectProviderARNs() != null) {
            sb.append("OpenIdConnectProviderARNs: " + this.getOpenIdConnectProviderARNs());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityPoolId() == null ? 0 : this.getIdentityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getIdentityPoolName() == null ? 0 : this.getIdentityPoolName().hashCode());
        hashCode = 31 * hashCode + (this.isAllowUnauthenticatedIdentities() == null ? 0 : this.isAllowUnauthenticatedIdentities().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedLoginProviders() == null ? 0 : this.getSupportedLoginProviders().hashCode());
        hashCode = 31 * hashCode + (this.getDeveloperProviderName() == null ? 0 : this.getDeveloperProviderName().hashCode());
        hashCode = 31 * hashCode + (this.getOpenIdConnectProviderARNs() == null ? 0 : this.getOpenIdConnectProviderARNs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentityPoolRequest)) {
            return false;
        }
        UpdateIdentityPoolRequest other = (UpdateIdentityPoolRequest)obj;
        if (other.getIdentityPoolId() == null ^ this.getIdentityPoolId() == null) {
            return false;
        }
        if (other.getIdentityPoolId() != null && !other.getIdentityPoolId().equals(this.getIdentityPoolId())) {
            return false;
        }
        if (other.getIdentityPoolName() == null ^ this.getIdentityPoolName() == null) {
            return false;
        }
        if (other.getIdentityPoolName() != null && !other.getIdentityPoolName().equals(this.getIdentityPoolName())) {
            return false;
        }
        if (other.isAllowUnauthenticatedIdentities() == null ^ this.isAllowUnauthenticatedIdentities() == null) {
            return false;
        }
        if (other.isAllowUnauthenticatedIdentities() != null && !other.isAllowUnauthenticatedIdentities().equals(this.isAllowUnauthenticatedIdentities())) {
            return false;
        }
        if (other.getSupportedLoginProviders() == null ^ this.getSupportedLoginProviders() == null) {
            return false;
        }
        if (other.getSupportedLoginProviders() != null && !other.getSupportedLoginProviders().equals(this.getSupportedLoginProviders())) {
            return false;
        }
        if (other.getDeveloperProviderName() == null ^ this.getDeveloperProviderName() == null) {
            return false;
        }
        if (other.getDeveloperProviderName() != null && !other.getDeveloperProviderName().equals(this.getDeveloperProviderName())) {
            return false;
        }
        if (other.getOpenIdConnectProviderARNs() == null ^ this.getOpenIdConnectProviderARNs() == null) {
            return false;
        }
        return other.getOpenIdConnectProviderARNs() == null || other.getOpenIdConnectProviderARNs().equals(this.getOpenIdConnectProviderARNs());
    }
}

