/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidentity.model.RoleMapping;
import com.amazonaws.services.cognitoidentity.model.SetIdentityPoolRolesRequest;
import com.amazonaws.services.cognitoidentity.model.transform.RoleMappingJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class SetIdentityPoolRolesRequestMarshaller
implements Marshaller<Request<SetIdentityPoolRolesRequest>, SetIdentityPoolRolesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SetIdentityPoolRolesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SetIdentityPoolRolesRequest> marshall(SetIdentityPoolRolesRequest setIdentityPoolRolesRequest) {
        if (setIdentityPoolRolesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setIdentityPoolRolesRequest, "AmazonCognitoIdentity");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityService.SetIdentityPoolRoles");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, RoleMapping> roleMappingsMap;
            Map<String, String> rolesMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (setIdentityPoolRolesRequest.getIdentityPoolId() != null) {
                jsonGenerator.writeFieldName("IdentityPoolId").writeValue(setIdentityPoolRolesRequest.getIdentityPoolId());
            }
            if ((rolesMap = setIdentityPoolRolesRequest.getRoles()) != null) {
                jsonGenerator.writeFieldName("Roles");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> rolesMapValue : rolesMap.entrySet()) {
                    if (rolesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)rolesMapValue.getKey());
                    jsonGenerator.writeValue((String)rolesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((roleMappingsMap = setIdentityPoolRolesRequest.getRoleMappings()) != null) {
                jsonGenerator.writeFieldName("RoleMappings");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : roleMappingsMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    RoleMappingJsonMarshaller.getInstance().marshall((RoleMapping)entry.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

