/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidentity.model.CognitoIdentityProvider;
import com.amazonaws.services.cognitoidentity.model.CreateIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.transform.CognitoIdentityProviderJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class CreateIdentityPoolRequestMarshaller
implements Marshaller<Request<CreateIdentityPoolRequest>, CreateIdentityPoolRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateIdentityPoolRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateIdentityPoolRequest> marshall(CreateIdentityPoolRequest createIdentityPoolRequest) {
        if (createIdentityPoolRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createIdentityPoolRequest, "AmazonCognitoIdentity");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityService.CreateIdentityPool");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> list;
            List<CognitoIdentityProvider> cognitoIdentityProvidersList;
            List<String> openIdConnectProviderARNsList;
            Map<String, String> supportedLoginProvidersMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createIdentityPoolRequest.getIdentityPoolName() != null) {
                jsonGenerator.writeFieldName("IdentityPoolName").writeValue(createIdentityPoolRequest.getIdentityPoolName());
            }
            if (createIdentityPoolRequest.getAllowUnauthenticatedIdentities() != null) {
                jsonGenerator.writeFieldName("AllowUnauthenticatedIdentities").writeValue(createIdentityPoolRequest.getAllowUnauthenticatedIdentities().booleanValue());
            }
            if ((supportedLoginProvidersMap = createIdentityPoolRequest.getSupportedLoginProviders()) != null) {
                jsonGenerator.writeFieldName("SupportedLoginProviders");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> supportedLoginProvidersMapValue : supportedLoginProvidersMap.entrySet()) {
                    if (supportedLoginProvidersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)supportedLoginProvidersMapValue.getKey());
                    jsonGenerator.writeValue((String)supportedLoginProvidersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (createIdentityPoolRequest.getDeveloperProviderName() != null) {
                jsonGenerator.writeFieldName("DeveloperProviderName").writeValue(createIdentityPoolRequest.getDeveloperProviderName());
            }
            if ((openIdConnectProviderARNsList = createIdentityPoolRequest.getOpenIdConnectProviderARNs()) != null) {
                jsonGenerator.writeFieldName("OpenIdConnectProviderARNs");
                jsonGenerator.writeStartArray();
                for (String string : openIdConnectProviderARNsList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((cognitoIdentityProvidersList = createIdentityPoolRequest.getCognitoIdentityProviders()) != null) {
                jsonGenerator.writeFieldName("CognitoIdentityProviders");
                jsonGenerator.writeStartArray();
                for (CognitoIdentityProvider cognitoIdentityProvider : cognitoIdentityProvidersList) {
                    if (cognitoIdentityProvider == null) continue;
                    CognitoIdentityProviderJsonMarshaller.getInstance().marshall(cognitoIdentityProvider, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = createIdentityPoolRequest.getSamlProviderARNs()) != null) {
                jsonGenerator.writeFieldName("SamlProviderARNs");
                jsonGenerator.writeStartArray();
                for (String samlProviderARNsListValue : list) {
                    if (samlProviderARNsListValue == null) continue;
                    jsonGenerator.writeValue(samlProviderARNsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

