/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentitiesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class DeleteIdentitiesRequestMarshaller
implements Marshaller<Request<DeleteIdentitiesRequest>, DeleteIdentitiesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteIdentitiesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteIdentitiesRequest> marshall(DeleteIdentitiesRequest deleteIdentitiesRequest) {
        if (deleteIdentitiesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteIdentitiesRequest, "AmazonCognitoIdentity");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityService.DeleteIdentities");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> identityIdsToDeleteList = deleteIdentitiesRequest.getIdentityIdsToDelete();
            if (identityIdsToDeleteList != null) {
                jsonGenerator.writeFieldName("IdentityIdsToDelete");
                jsonGenerator.writeStartArray();
                for (String identityIdsToDeleteListValue : identityIdsToDeleteList) {
                    if (identityIdsToDeleteListValue == null) continue;
                    jsonGenerator.writeValue(identityIdsToDeleteListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

