/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.services.cognitoidentity.model.CognitoIdentityProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateIdentityPoolResult
implements Serializable,
Cloneable {
    private String identityPoolId;
    private String identityPoolName;
    private Boolean allowUnauthenticatedIdentities;
    private Map<String, String> supportedLoginProviders;
    private String developerProviderName;
    private List<String> openIdConnectProviderARNs;
    private List<CognitoIdentityProvider> cognitoIdentityProviders;
    private List<String> samlProviderARNs;

    public void setIdentityPoolId(String identityPoolId) {
        this.identityPoolId = identityPoolId;
    }

    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public UpdateIdentityPoolResult withIdentityPoolId(String identityPoolId) {
        this.setIdentityPoolId(identityPoolId);
        return this;
    }

    public void setIdentityPoolName(String identityPoolName) {
        this.identityPoolName = identityPoolName;
    }

    public String getIdentityPoolName() {
        return this.identityPoolName;
    }

    public UpdateIdentityPoolResult withIdentityPoolName(String identityPoolName) {
        this.setIdentityPoolName(identityPoolName);
        return this;
    }

    public void setAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
        this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
    }

    public Boolean getAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public UpdateIdentityPoolResult withAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
        this.setAllowUnauthenticatedIdentities(allowUnauthenticatedIdentities);
        return this;
    }

    public Boolean isAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public Map<String, String> getSupportedLoginProviders() {
        return this.supportedLoginProviders;
    }

    public void setSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
        this.supportedLoginProviders = supportedLoginProviders;
    }

    public UpdateIdentityPoolResult withSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
        this.setSupportedLoginProviders(supportedLoginProviders);
        return this;
    }

    public UpdateIdentityPoolResult addSupportedLoginProvidersEntry(String key, String value) {
        if (null == this.supportedLoginProviders) {
            this.supportedLoginProviders = new HashMap<String, String>();
        }
        if (this.supportedLoginProviders.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.supportedLoginProviders.put(key, value);
        return this;
    }

    public UpdateIdentityPoolResult clearSupportedLoginProvidersEntries() {
        this.supportedLoginProviders = null;
        return this;
    }

    public void setDeveloperProviderName(String developerProviderName) {
        this.developerProviderName = developerProviderName;
    }

    public String getDeveloperProviderName() {
        return this.developerProviderName;
    }

    public UpdateIdentityPoolResult withDeveloperProviderName(String developerProviderName) {
        this.setDeveloperProviderName(developerProviderName);
        return this;
    }

    public List<String> getOpenIdConnectProviderARNs() {
        return this.openIdConnectProviderARNs;
    }

    public void setOpenIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
        if (openIdConnectProviderARNs == null) {
            this.openIdConnectProviderARNs = null;
            return;
        }
        this.openIdConnectProviderARNs = new ArrayList<String>(openIdConnectProviderARNs);
    }

    public UpdateIdentityPoolResult withOpenIdConnectProviderARNs(String ... openIdConnectProviderARNs) {
        if (this.openIdConnectProviderARNs == null) {
            this.setOpenIdConnectProviderARNs(new ArrayList<String>(openIdConnectProviderARNs.length));
        }
        for (String ele : openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs.add(ele);
        }
        return this;
    }

    public UpdateIdentityPoolResult withOpenIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
        this.setOpenIdConnectProviderARNs(openIdConnectProviderARNs);
        return this;
    }

    public List<CognitoIdentityProvider> getCognitoIdentityProviders() {
        return this.cognitoIdentityProviders;
    }

    public void setCognitoIdentityProviders(Collection<CognitoIdentityProvider> cognitoIdentityProviders) {
        if (cognitoIdentityProviders == null) {
            this.cognitoIdentityProviders = null;
            return;
        }
        this.cognitoIdentityProviders = new ArrayList<CognitoIdentityProvider>(cognitoIdentityProviders);
    }

    public UpdateIdentityPoolResult withCognitoIdentityProviders(CognitoIdentityProvider ... cognitoIdentityProviders) {
        if (this.cognitoIdentityProviders == null) {
            this.setCognitoIdentityProviders(new ArrayList<CognitoIdentityProvider>(cognitoIdentityProviders.length));
        }
        for (CognitoIdentityProvider ele : cognitoIdentityProviders) {
            this.cognitoIdentityProviders.add(ele);
        }
        return this;
    }

    public UpdateIdentityPoolResult withCognitoIdentityProviders(Collection<CognitoIdentityProvider> cognitoIdentityProviders) {
        this.setCognitoIdentityProviders(cognitoIdentityProviders);
        return this;
    }

    public List<String> getSamlProviderARNs() {
        return this.samlProviderARNs;
    }

    public void setSamlProviderARNs(Collection<String> samlProviderARNs) {
        if (samlProviderARNs == null) {
            this.samlProviderARNs = null;
            return;
        }
        this.samlProviderARNs = new ArrayList<String>(samlProviderARNs);
    }

    public UpdateIdentityPoolResult withSamlProviderARNs(String ... samlProviderARNs) {
        if (this.samlProviderARNs == null) {
            this.setSamlProviderARNs(new ArrayList<String>(samlProviderARNs.length));
        }
        for (String ele : samlProviderARNs) {
            this.samlProviderARNs.add(ele);
        }
        return this;
    }

    public UpdateIdentityPoolResult withSamlProviderARNs(Collection<String> samlProviderARNs) {
        this.setSamlProviderARNs(samlProviderARNs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityPoolId() != null) {
            sb.append("IdentityPoolId: " + this.getIdentityPoolId() + ",");
        }
        if (this.getIdentityPoolName() != null) {
            sb.append("IdentityPoolName: " + this.getIdentityPoolName() + ",");
        }
        if (this.getAllowUnauthenticatedIdentities() != null) {
            sb.append("AllowUnauthenticatedIdentities: " + this.getAllowUnauthenticatedIdentities() + ",");
        }
        if (this.getSupportedLoginProviders() != null) {
            sb.append("SupportedLoginProviders: " + this.getSupportedLoginProviders() + ",");
        }
        if (this.getDeveloperProviderName() != null) {
            sb.append("DeveloperProviderName: " + this.getDeveloperProviderName() + ",");
        }
        if (this.getOpenIdConnectProviderARNs() != null) {
            sb.append("OpenIdConnectProviderARNs: " + this.getOpenIdConnectProviderARNs() + ",");
        }
        if (this.getCognitoIdentityProviders() != null) {
            sb.append("CognitoIdentityProviders: " + this.getCognitoIdentityProviders() + ",");
        }
        if (this.getSamlProviderARNs() != null) {
            sb.append("SamlProviderARNs: " + this.getSamlProviderARNs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentityPoolResult)) {
            return false;
        }
        UpdateIdentityPoolResult other = (UpdateIdentityPoolResult)obj;
        if (other.getIdentityPoolId() == null ^ this.getIdentityPoolId() == null) {
            return false;
        }
        if (other.getIdentityPoolId() != null && !other.getIdentityPoolId().equals(this.getIdentityPoolId())) {
            return false;
        }
        if (other.getIdentityPoolName() == null ^ this.getIdentityPoolName() == null) {
            return false;
        }
        if (other.getIdentityPoolName() != null && !other.getIdentityPoolName().equals(this.getIdentityPoolName())) {
            return false;
        }
        if (other.getAllowUnauthenticatedIdentities() == null ^ this.getAllowUnauthenticatedIdentities() == null) {
            return false;
        }
        if (other.getAllowUnauthenticatedIdentities() != null && !other.getAllowUnauthenticatedIdentities().equals(this.getAllowUnauthenticatedIdentities())) {
            return false;
        }
        if (other.getSupportedLoginProviders() == null ^ this.getSupportedLoginProviders() == null) {
            return false;
        }
        if (other.getSupportedLoginProviders() != null && !other.getSupportedLoginProviders().equals(this.getSupportedLoginProviders())) {
            return false;
        }
        if (other.getDeveloperProviderName() == null ^ this.getDeveloperProviderName() == null) {
            return false;
        }
        if (other.getDeveloperProviderName() != null && !other.getDeveloperProviderName().equals(this.getDeveloperProviderName())) {
            return false;
        }
        if (other.getOpenIdConnectProviderARNs() == null ^ this.getOpenIdConnectProviderARNs() == null) {
            return false;
        }
        if (other.getOpenIdConnectProviderARNs() != null && !other.getOpenIdConnectProviderARNs().equals(this.getOpenIdConnectProviderARNs())) {
            return false;
        }
        if (other.getCognitoIdentityProviders() == null ^ this.getCognitoIdentityProviders() == null) {
            return false;
        }
        if (other.getCognitoIdentityProviders() != null && !other.getCognitoIdentityProviders().equals(this.getCognitoIdentityProviders())) {
            return false;
        }
        if (other.getSamlProviderARNs() == null ^ this.getSamlProviderARNs() == null) {
            return false;
        }
        return other.getSamlProviderARNs() == null || other.getSamlProviderARNs().equals(this.getSamlProviderARNs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityPoolId() == null ? 0 : this.getIdentityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getIdentityPoolName() == null ? 0 : this.getIdentityPoolName().hashCode());
        hashCode = 31 * hashCode + (this.getAllowUnauthenticatedIdentities() == null ? 0 : this.getAllowUnauthenticatedIdentities().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedLoginProviders() == null ? 0 : this.getSupportedLoginProviders().hashCode());
        hashCode = 31 * hashCode + (this.getDeveloperProviderName() == null ? 0 : this.getDeveloperProviderName().hashCode());
        hashCode = 31 * hashCode + (this.getOpenIdConnectProviderARNs() == null ? 0 : this.getOpenIdConnectProviderARNs().hashCode());
        hashCode = 31 * hashCode + (this.getCognitoIdentityProviders() == null ? 0 : this.getCognitoIdentityProviders().hashCode());
        hashCode = 31 * hashCode + (this.getSamlProviderARNs() == null ? 0 : this.getSamlProviderARNs().hashCode());
        return hashCode;
    }

    public UpdateIdentityPoolResult clone() {
        try {
            return (UpdateIdentityPoolResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

