/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cognitoidentity.model.Credentials;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class CredentialsJsonMarshaller {
    private static CredentialsJsonMarshaller instance;

    public void marshall(Credentials credentials, StructuredJsonGenerator jsonGenerator) {
        if (credentials == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (credentials.getAccessKeyId() != null) {
                jsonGenerator.writeFieldName("AccessKeyId").writeValue(credentials.getAccessKeyId());
            }
            if (credentials.getSecretKey() != null) {
                jsonGenerator.writeFieldName("SecretKey").writeValue(credentials.getSecretKey());
            }
            if (credentials.getSessionToken() != null) {
                jsonGenerator.writeFieldName("SessionToken").writeValue(credentials.getSessionToken());
            }
            if (credentials.getExpiration() != null) {
                jsonGenerator.writeFieldName("Expiration").writeValue(credentials.getExpiration());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CredentialsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CredentialsJsonMarshaller();
        }
        return instance;
    }
}

