/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cognitoidentity.model.Credentials;
import com.amazonaws.util.json.JSONWriter;

public class CredentialsJsonMarshaller {
    private static CredentialsJsonMarshaller instance;

    public void marshall(Credentials credentials, JSONWriter jsonWriter) {
        if (credentials == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (credentials.getAccessKeyId() != null) {
                jsonWriter.key("AccessKeyId").value((Object)credentials.getAccessKeyId());
            }
            if (credentials.getSecretKey() != null) {
                jsonWriter.key("SecretKey").value((Object)credentials.getSecretKey());
            }
            if (credentials.getSessionToken() != null) {
                jsonWriter.key("SessionToken").value((Object)credentials.getSessionToken());
            }
            if (credentials.getExpiration() != null) {
                jsonWriter.key("Expiration").value(credentials.getExpiration());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CredentialsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CredentialsJsonMarshaller();
        }
        return instance;
    }
}

