/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestar;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.codestar.AWSCodeStar;
import com.amazonaws.services.codestar.AWSCodeStarClientBuilder;
import com.amazonaws.services.codestar.model.AWSCodeStarException;
import com.amazonaws.services.codestar.model.AssociateTeamMemberRequest;
import com.amazonaws.services.codestar.model.AssociateTeamMemberResult;
import com.amazonaws.services.codestar.model.CreateProjectRequest;
import com.amazonaws.services.codestar.model.CreateProjectResult;
import com.amazonaws.services.codestar.model.CreateUserProfileRequest;
import com.amazonaws.services.codestar.model.CreateUserProfileResult;
import com.amazonaws.services.codestar.model.DeleteProjectRequest;
import com.amazonaws.services.codestar.model.DeleteProjectResult;
import com.amazonaws.services.codestar.model.DeleteUserProfileRequest;
import com.amazonaws.services.codestar.model.DeleteUserProfileResult;
import com.amazonaws.services.codestar.model.DescribeProjectRequest;
import com.amazonaws.services.codestar.model.DescribeProjectResult;
import com.amazonaws.services.codestar.model.DescribeUserProfileRequest;
import com.amazonaws.services.codestar.model.DescribeUserProfileResult;
import com.amazonaws.services.codestar.model.DisassociateTeamMemberRequest;
import com.amazonaws.services.codestar.model.DisassociateTeamMemberResult;
import com.amazonaws.services.codestar.model.ListProjectsRequest;
import com.amazonaws.services.codestar.model.ListProjectsResult;
import com.amazonaws.services.codestar.model.ListResourcesRequest;
import com.amazonaws.services.codestar.model.ListResourcesResult;
import com.amazonaws.services.codestar.model.ListTagsForProjectRequest;
import com.amazonaws.services.codestar.model.ListTagsForProjectResult;
import com.amazonaws.services.codestar.model.ListTeamMembersRequest;
import com.amazonaws.services.codestar.model.ListTeamMembersResult;
import com.amazonaws.services.codestar.model.ListUserProfilesRequest;
import com.amazonaws.services.codestar.model.ListUserProfilesResult;
import com.amazonaws.services.codestar.model.TagProjectRequest;
import com.amazonaws.services.codestar.model.TagProjectResult;
import com.amazonaws.services.codestar.model.UntagProjectRequest;
import com.amazonaws.services.codestar.model.UntagProjectResult;
import com.amazonaws.services.codestar.model.UpdateProjectRequest;
import com.amazonaws.services.codestar.model.UpdateProjectResult;
import com.amazonaws.services.codestar.model.UpdateTeamMemberRequest;
import com.amazonaws.services.codestar.model.UpdateTeamMemberResult;
import com.amazonaws.services.codestar.model.UpdateUserProfileRequest;
import com.amazonaws.services.codestar.model.UpdateUserProfileResult;
import com.amazonaws.services.codestar.model.transform.AssociateTeamMemberRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.AssociateTeamMemberResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.ConcurrentModificationExceptionUnmarshaller;
import com.amazonaws.services.codestar.model.transform.CreateProjectRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.CreateProjectResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.CreateUserProfileRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.CreateUserProfileResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.DeleteProjectRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.DeleteProjectResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.DeleteUserProfileRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.DeleteUserProfileResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.DescribeProjectRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.DescribeProjectResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.DescribeUserProfileRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.DescribeUserProfileResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.DisassociateTeamMemberRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.DisassociateTeamMemberResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.codestar.model.transform.InvalidServiceRoleExceptionUnmarshaller;
import com.amazonaws.services.codestar.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.codestar.model.transform.ListProjectsRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.ListProjectsResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.ListResourcesRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.ListResourcesResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.ListTagsForProjectRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.ListTagsForProjectResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.ListTeamMembersRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.ListTeamMembersResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.ListUserProfilesRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.ListUserProfilesResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.ProjectAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.codestar.model.transform.ProjectConfigurationExceptionUnmarshaller;
import com.amazonaws.services.codestar.model.transform.ProjectCreationFailedExceptionUnmarshaller;
import com.amazonaws.services.codestar.model.transform.ProjectNotFoundExceptionUnmarshaller;
import com.amazonaws.services.codestar.model.transform.TagProjectRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.TagProjectResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.TeamMemberAlreadyAssociatedExceptionUnmarshaller;
import com.amazonaws.services.codestar.model.transform.TeamMemberNotFoundExceptionUnmarshaller;
import com.amazonaws.services.codestar.model.transform.UntagProjectRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.UntagProjectResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.UpdateProjectRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.UpdateProjectResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.UpdateTeamMemberRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.UpdateTeamMemberResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.UpdateUserProfileRequestProtocolMarshaller;
import com.amazonaws.services.codestar.model.transform.UpdateUserProfileResultJsonUnmarshaller;
import com.amazonaws.services.codestar.model.transform.UserProfileAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.codestar.model.transform.UserProfileNotFoundExceptionUnmarshaller;
import com.amazonaws.services.codestar.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCodeStarClient
extends AmazonWebServiceClient
implements AWSCodeStar {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCodeStar.class);
    private static final String DEFAULT_SIGNING_NAME = "codestar";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConcurrentModificationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidServiceRoleException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidServiceRoleExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProjectAlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ProjectAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UserProfileAlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UserProfileAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProjectConfigurationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ProjectConfigurationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProjectNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ProjectNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProjectCreationFailedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ProjectCreationFailedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TeamMemberAlreadyAssociatedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TeamMemberAlreadyAssociatedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UserProfileNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UserProfileNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TeamMemberNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TeamMemberNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidNextTokenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSCodeStarException.class));

    public static AWSCodeStarClientBuilder builder() {
        return AWSCodeStarClientBuilder.standard();
    }

    AWSCodeStarClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSCodeStarClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("codestar.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/codestar/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/codestar/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateTeamMemberResult associateTeamMember(AssociateTeamMemberRequest request) {
        request = (AssociateTeamMemberRequest)this.beforeClientExecution(request);
        return this.executeAssociateTeamMember(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateTeamMemberResult executeAssociateTeamMember(AssociateTeamMemberRequest associateTeamMemberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateTeamMemberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateTeamMemberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateTeamMemberRequestProtocolMarshaller(protocolFactory).marshall((AssociateTeamMemberRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateTeamMemberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateTeamMember");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateTeamMemberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateTeamMemberResult associateTeamMemberResult = (AssociateTeamMemberResult)response.getAwsResponse();
            return associateTeamMemberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateProjectResult createProject(CreateProjectRequest request) {
        request = (CreateProjectRequest)this.beforeClientExecution(request);
        return this.executeCreateProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProjectResult executeCreateProject(CreateProjectRequest createProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProjectRequestProtocolMarshaller(protocolFactory).marshall((CreateProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)createProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateProject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProjectResult createProjectResult = (CreateProjectResult)response.getAwsResponse();
            return createProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateUserProfileResult createUserProfile(CreateUserProfileRequest request) {
        request = (CreateUserProfileRequest)this.beforeClientExecution(request);
        return this.executeCreateUserProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateUserProfileResult executeCreateUserProfile(CreateUserProfileRequest createUserProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createUserProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateUserProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateUserProfileRequestProtocolMarshaller(protocolFactory).marshall((CreateUserProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)createUserProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateUserProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateUserProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateUserProfileResult createUserProfileResult = (CreateUserProfileResult)response.getAwsResponse();
            return createUserProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteProjectResult deleteProject(DeleteProjectRequest request) {
        request = (DeleteProjectRequest)this.beforeClientExecution(request);
        return this.executeDeleteProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteProjectResult executeDeleteProject(DeleteProjectRequest deleteProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProjectRequestProtocolMarshaller(protocolFactory).marshall((DeleteProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteProject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProjectResult deleteProjectResult = (DeleteProjectResult)response.getAwsResponse();
            return deleteProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteUserProfileResult deleteUserProfile(DeleteUserProfileRequest request) {
        request = (DeleteUserProfileRequest)this.beforeClientExecution(request);
        return this.executeDeleteUserProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteUserProfileResult executeDeleteUserProfile(DeleteUserProfileRequest deleteUserProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteUserProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteUserProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteUserProfileRequestProtocolMarshaller(protocolFactory).marshall((DeleteUserProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteUserProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteUserProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteUserProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteUserProfileResult deleteUserProfileResult = (DeleteUserProfileResult)response.getAwsResponse();
            return deleteUserProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeProjectResult describeProject(DescribeProjectRequest request) {
        request = (DescribeProjectRequest)this.beforeClientExecution(request);
        return this.executeDescribeProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeProjectResult executeDescribeProject(DescribeProjectRequest describeProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeProjectRequestProtocolMarshaller(protocolFactory).marshall((DescribeProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeProject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeProjectResult describeProjectResult = (DescribeProjectResult)response.getAwsResponse();
            return describeProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeUserProfileResult describeUserProfile(DescribeUserProfileRequest request) {
        request = (DescribeUserProfileRequest)this.beforeClientExecution(request);
        return this.executeDescribeUserProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeUserProfileResult executeDescribeUserProfile(DescribeUserProfileRequest describeUserProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeUserProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeUserProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeUserProfileRequestProtocolMarshaller(protocolFactory).marshall((DescribeUserProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeUserProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeUserProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeUserProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeUserProfileResult describeUserProfileResult = (DescribeUserProfileResult)response.getAwsResponse();
            return describeUserProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateTeamMemberResult disassociateTeamMember(DisassociateTeamMemberRequest request) {
        request = (DisassociateTeamMemberRequest)this.beforeClientExecution(request);
        return this.executeDisassociateTeamMember(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateTeamMemberResult executeDisassociateTeamMember(DisassociateTeamMemberRequest disassociateTeamMemberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateTeamMemberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateTeamMemberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateTeamMemberRequestProtocolMarshaller(protocolFactory).marshall((DisassociateTeamMemberRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateTeamMemberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateTeamMember");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateTeamMemberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateTeamMemberResult disassociateTeamMemberResult = (DisassociateTeamMemberResult)response.getAwsResponse();
            return disassociateTeamMemberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProjectsResult listProjects(ListProjectsRequest request) {
        request = (ListProjectsRequest)this.beforeClientExecution(request);
        return this.executeListProjects(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProjectsResult executeListProjects(ListProjectsRequest listProjectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProjectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProjectsRequestProtocolMarshaller(protocolFactory).marshall((ListProjectsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProjectsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProjects");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProjectsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProjectsResult listProjectsResult = (ListProjectsResult)response.getAwsResponse();
            return listProjectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListResourcesResult listResources(ListResourcesRequest request) {
        request = (ListResourcesRequest)this.beforeClientExecution(request);
        return this.executeListResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListResourcesResult executeListResources(ListResourcesRequest listResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListResourcesRequestProtocolMarshaller(protocolFactory).marshall((ListResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListResourcesResult listResourcesResult = (ListResourcesResult)response.getAwsResponse();
            return listResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForProjectResult listTagsForProject(ListTagsForProjectRequest request) {
        request = (ListTagsForProjectRequest)this.beforeClientExecution(request);
        return this.executeListTagsForProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForProjectResult executeListTagsForProject(ListTagsForProjectRequest listTagsForProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForProjectRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForProject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForProjectResult listTagsForProjectResult = (ListTagsForProjectResult)response.getAwsResponse();
            return listTagsForProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTeamMembersResult listTeamMembers(ListTeamMembersRequest request) {
        request = (ListTeamMembersRequest)this.beforeClientExecution(request);
        return this.executeListTeamMembers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTeamMembersResult executeListTeamMembers(ListTeamMembersRequest listTeamMembersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTeamMembersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTeamMembersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTeamMembersRequestProtocolMarshaller(protocolFactory).marshall((ListTeamMembersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTeamMembersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTeamMembers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTeamMembersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTeamMembersResult listTeamMembersResult = (ListTeamMembersResult)response.getAwsResponse();
            return listTeamMembersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListUserProfilesResult listUserProfiles(ListUserProfilesRequest request) {
        request = (ListUserProfilesRequest)this.beforeClientExecution(request);
        return this.executeListUserProfiles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListUserProfilesResult executeListUserProfiles(ListUserProfilesRequest listUserProfilesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listUserProfilesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListUserProfilesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListUserProfilesRequestProtocolMarshaller(protocolFactory).marshall((ListUserProfilesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listUserProfilesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListUserProfiles");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListUserProfilesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListUserProfilesResult listUserProfilesResult = (ListUserProfilesResult)response.getAwsResponse();
            return listUserProfilesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagProjectResult tagProject(TagProjectRequest request) {
        request = (TagProjectRequest)this.beforeClientExecution(request);
        return this.executeTagProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagProjectResult executeTagProject(TagProjectRequest tagProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagProjectRequestProtocolMarshaller(protocolFactory).marshall((TagProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagProject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagProjectResult tagProjectResult = (TagProjectResult)response.getAwsResponse();
            return tagProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagProjectResult untagProject(UntagProjectRequest request) {
        request = (UntagProjectRequest)this.beforeClientExecution(request);
        return this.executeUntagProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagProjectResult executeUntagProject(UntagProjectRequest untagProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagProjectRequestProtocolMarshaller(protocolFactory).marshall((UntagProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagProject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagProjectResult untagProjectResult = (UntagProjectResult)response.getAwsResponse();
            return untagProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateProjectResult updateProject(UpdateProjectRequest request) {
        request = (UpdateProjectRequest)this.beforeClientExecution(request);
        return this.executeUpdateProject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateProjectResult executeUpdateProject(UpdateProjectRequest updateProjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateProjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateProjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateProjectRequestProtocolMarshaller(protocolFactory).marshall((UpdateProjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateProjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateProject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateProjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateProjectResult updateProjectResult = (UpdateProjectResult)response.getAwsResponse();
            return updateProjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateTeamMemberResult updateTeamMember(UpdateTeamMemberRequest request) {
        request = (UpdateTeamMemberRequest)this.beforeClientExecution(request);
        return this.executeUpdateTeamMember(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateTeamMemberResult executeUpdateTeamMember(UpdateTeamMemberRequest updateTeamMemberRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTeamMemberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTeamMemberRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTeamMemberRequestProtocolMarshaller(protocolFactory).marshall((UpdateTeamMemberRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateTeamMemberRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateTeamMember");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateTeamMemberResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateTeamMemberResult updateTeamMemberResult = (UpdateTeamMemberResult)response.getAwsResponse();
            return updateTeamMemberResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateUserProfileResult updateUserProfile(UpdateUserProfileRequest request) {
        request = (UpdateUserProfileRequest)this.beforeClientExecution(request);
        return this.executeUpdateUserProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateUserProfileResult executeUpdateUserProfile(UpdateUserProfileRequest updateUserProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateUserProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateUserProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateUserProfileRequestProtocolMarshaller(protocolFactory).marshall((UpdateUserProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateUserProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"CodeStar");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateUserProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateUserProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateUserProfileResult updateUserProfileResult = (UpdateUserProfileResult)response.getAwsResponse();
            return updateUserProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

