/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.ActionState;
import com.amazonaws.services.codepipeline.model.StageConditionState;
import com.amazonaws.services.codepipeline.model.StageExecution;
import com.amazonaws.services.codepipeline.model.TransitionState;
import com.amazonaws.services.codepipeline.model.transform.StageStateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StageState
implements Serializable,
Cloneable,
StructuredPojo {
    private String stageName;
    private StageExecution inboundExecution;
    private List<StageExecution> inboundExecutions;
    private TransitionState inboundTransitionState;
    private List<ActionState> actionStates;
    private StageExecution latestExecution;
    private StageConditionState beforeEntryConditionState;
    private StageConditionState onSuccessConditionState;
    private StageConditionState onFailureConditionState;

    public void setStageName(String stageName) {
        this.stageName = stageName;
    }

    public String getStageName() {
        return this.stageName;
    }

    public StageState withStageName(String stageName) {
        this.setStageName(stageName);
        return this;
    }

    public void setInboundExecution(StageExecution inboundExecution) {
        this.inboundExecution = inboundExecution;
    }

    public StageExecution getInboundExecution() {
        return this.inboundExecution;
    }

    public StageState withInboundExecution(StageExecution inboundExecution) {
        this.setInboundExecution(inboundExecution);
        return this;
    }

    public List<StageExecution> getInboundExecutions() {
        return this.inboundExecutions;
    }

    public void setInboundExecutions(Collection<StageExecution> inboundExecutions) {
        if (inboundExecutions == null) {
            this.inboundExecutions = null;
            return;
        }
        this.inboundExecutions = new ArrayList<StageExecution>(inboundExecutions);
    }

    public StageState withInboundExecutions(StageExecution ... inboundExecutions) {
        if (this.inboundExecutions == null) {
            this.setInboundExecutions(new ArrayList<StageExecution>(inboundExecutions.length));
        }
        for (StageExecution ele : inboundExecutions) {
            this.inboundExecutions.add(ele);
        }
        return this;
    }

    public StageState withInboundExecutions(Collection<StageExecution> inboundExecutions) {
        this.setInboundExecutions(inboundExecutions);
        return this;
    }

    public void setInboundTransitionState(TransitionState inboundTransitionState) {
        this.inboundTransitionState = inboundTransitionState;
    }

    public TransitionState getInboundTransitionState() {
        return this.inboundTransitionState;
    }

    public StageState withInboundTransitionState(TransitionState inboundTransitionState) {
        this.setInboundTransitionState(inboundTransitionState);
        return this;
    }

    public List<ActionState> getActionStates() {
        return this.actionStates;
    }

    public void setActionStates(Collection<ActionState> actionStates) {
        if (actionStates == null) {
            this.actionStates = null;
            return;
        }
        this.actionStates = new ArrayList<ActionState>(actionStates);
    }

    public StageState withActionStates(ActionState ... actionStates) {
        if (this.actionStates == null) {
            this.setActionStates(new ArrayList<ActionState>(actionStates.length));
        }
        for (ActionState ele : actionStates) {
            this.actionStates.add(ele);
        }
        return this;
    }

    public StageState withActionStates(Collection<ActionState> actionStates) {
        this.setActionStates(actionStates);
        return this;
    }

    public void setLatestExecution(StageExecution latestExecution) {
        this.latestExecution = latestExecution;
    }

    public StageExecution getLatestExecution() {
        return this.latestExecution;
    }

    public StageState withLatestExecution(StageExecution latestExecution) {
        this.setLatestExecution(latestExecution);
        return this;
    }

    public void setBeforeEntryConditionState(StageConditionState beforeEntryConditionState) {
        this.beforeEntryConditionState = beforeEntryConditionState;
    }

    public StageConditionState getBeforeEntryConditionState() {
        return this.beforeEntryConditionState;
    }

    public StageState withBeforeEntryConditionState(StageConditionState beforeEntryConditionState) {
        this.setBeforeEntryConditionState(beforeEntryConditionState);
        return this;
    }

    public void setOnSuccessConditionState(StageConditionState onSuccessConditionState) {
        this.onSuccessConditionState = onSuccessConditionState;
    }

    public StageConditionState getOnSuccessConditionState() {
        return this.onSuccessConditionState;
    }

    public StageState withOnSuccessConditionState(StageConditionState onSuccessConditionState) {
        this.setOnSuccessConditionState(onSuccessConditionState);
        return this;
    }

    public void setOnFailureConditionState(StageConditionState onFailureConditionState) {
        this.onFailureConditionState = onFailureConditionState;
    }

    public StageConditionState getOnFailureConditionState() {
        return this.onFailureConditionState;
    }

    public StageState withOnFailureConditionState(StageConditionState onFailureConditionState) {
        this.setOnFailureConditionState(onFailureConditionState);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStageName() != null) {
            sb.append("StageName: ").append(this.getStageName()).append(",");
        }
        if (this.getInboundExecution() != null) {
            sb.append("InboundExecution: ").append(this.getInboundExecution()).append(",");
        }
        if (this.getInboundExecutions() != null) {
            sb.append("InboundExecutions: ").append(this.getInboundExecutions()).append(",");
        }
        if (this.getInboundTransitionState() != null) {
            sb.append("InboundTransitionState: ").append(this.getInboundTransitionState()).append(",");
        }
        if (this.getActionStates() != null) {
            sb.append("ActionStates: ").append(this.getActionStates()).append(",");
        }
        if (this.getLatestExecution() != null) {
            sb.append("LatestExecution: ").append(this.getLatestExecution()).append(",");
        }
        if (this.getBeforeEntryConditionState() != null) {
            sb.append("BeforeEntryConditionState: ").append(this.getBeforeEntryConditionState()).append(",");
        }
        if (this.getOnSuccessConditionState() != null) {
            sb.append("OnSuccessConditionState: ").append(this.getOnSuccessConditionState()).append(",");
        }
        if (this.getOnFailureConditionState() != null) {
            sb.append("OnFailureConditionState: ").append(this.getOnFailureConditionState());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageState)) {
            return false;
        }
        StageState other = (StageState)obj;
        if (other.getStageName() == null ^ this.getStageName() == null) {
            return false;
        }
        if (other.getStageName() != null && !other.getStageName().equals(this.getStageName())) {
            return false;
        }
        if (other.getInboundExecution() == null ^ this.getInboundExecution() == null) {
            return false;
        }
        if (other.getInboundExecution() != null && !other.getInboundExecution().equals(this.getInboundExecution())) {
            return false;
        }
        if (other.getInboundExecutions() == null ^ this.getInboundExecutions() == null) {
            return false;
        }
        if (other.getInboundExecutions() != null && !other.getInboundExecutions().equals(this.getInboundExecutions())) {
            return false;
        }
        if (other.getInboundTransitionState() == null ^ this.getInboundTransitionState() == null) {
            return false;
        }
        if (other.getInboundTransitionState() != null && !other.getInboundTransitionState().equals(this.getInboundTransitionState())) {
            return false;
        }
        if (other.getActionStates() == null ^ this.getActionStates() == null) {
            return false;
        }
        if (other.getActionStates() != null && !other.getActionStates().equals(this.getActionStates())) {
            return false;
        }
        if (other.getLatestExecution() == null ^ this.getLatestExecution() == null) {
            return false;
        }
        if (other.getLatestExecution() != null && !other.getLatestExecution().equals(this.getLatestExecution())) {
            return false;
        }
        if (other.getBeforeEntryConditionState() == null ^ this.getBeforeEntryConditionState() == null) {
            return false;
        }
        if (other.getBeforeEntryConditionState() != null && !other.getBeforeEntryConditionState().equals(this.getBeforeEntryConditionState())) {
            return false;
        }
        if (other.getOnSuccessConditionState() == null ^ this.getOnSuccessConditionState() == null) {
            return false;
        }
        if (other.getOnSuccessConditionState() != null && !other.getOnSuccessConditionState().equals(this.getOnSuccessConditionState())) {
            return false;
        }
        if (other.getOnFailureConditionState() == null ^ this.getOnFailureConditionState() == null) {
            return false;
        }
        return other.getOnFailureConditionState() == null || other.getOnFailureConditionState().equals(this.getOnFailureConditionState());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStageName() == null ? 0 : this.getStageName().hashCode());
        hashCode = 31 * hashCode + (this.getInboundExecution() == null ? 0 : this.getInboundExecution().hashCode());
        hashCode = 31 * hashCode + (this.getInboundExecutions() == null ? 0 : this.getInboundExecutions().hashCode());
        hashCode = 31 * hashCode + (this.getInboundTransitionState() == null ? 0 : this.getInboundTransitionState().hashCode());
        hashCode = 31 * hashCode + (this.getActionStates() == null ? 0 : this.getActionStates().hashCode());
        hashCode = 31 * hashCode + (this.getLatestExecution() == null ? 0 : this.getLatestExecution().hashCode());
        hashCode = 31 * hashCode + (this.getBeforeEntryConditionState() == null ? 0 : this.getBeforeEntryConditionState().hashCode());
        hashCode = 31 * hashCode + (this.getOnSuccessConditionState() == null ? 0 : this.getOnSuccessConditionState().hashCode());
        hashCode = 31 * hashCode + (this.getOnFailureConditionState() == null ? 0 : this.getOnFailureConditionState().hashCode());
        return hashCode;
    }

    public StageState clone() {
        try {
            return (StageState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StageStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

