/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.Result;
import com.amazonaws.services.codepipeline.model.RuleDeclaration;
import com.amazonaws.services.codepipeline.model.transform.ConditionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Condition
implements Serializable,
Cloneable,
StructuredPojo {
    private String result;
    private List<RuleDeclaration> rules;

    public void setResult(String result) {
        this.result = result;
    }

    public String getResult() {
        return this.result;
    }

    public Condition withResult(String result) {
        this.setResult(result);
        return this;
    }

    public Condition withResult(Result result) {
        this.result = result.toString();
        return this;
    }

    public List<RuleDeclaration> getRules() {
        return this.rules;
    }

    public void setRules(Collection<RuleDeclaration> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<RuleDeclaration>(rules);
    }

    public Condition withRules(RuleDeclaration ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<RuleDeclaration>(rules.length));
        }
        for (RuleDeclaration ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public Condition withRules(Collection<RuleDeclaration> rules) {
        this.setRules(rules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResult() != null) {
            sb.append("Result: ").append(this.getResult()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)obj;
        if (other.getResult() == null ^ this.getResult() == null) {
            return false;
        }
        if (other.getResult() != null && !other.getResult().equals(this.getResult())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResult() == null ? 0 : this.getResult().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public Condition clone() {
        try {
            return (Condition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConditionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

