/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.codepipeline.AWSCodePipeline;
import com.amazonaws.services.codepipeline.AWSCodePipelineClientBuilder;
import com.amazonaws.services.codepipeline.model.AWSCodePipelineException;
import com.amazonaws.services.codepipeline.model.AcknowledgeJobRequest;
import com.amazonaws.services.codepipeline.model.AcknowledgeJobResult;
import com.amazonaws.services.codepipeline.model.AcknowledgeThirdPartyJobRequest;
import com.amazonaws.services.codepipeline.model.AcknowledgeThirdPartyJobResult;
import com.amazonaws.services.codepipeline.model.ActionNotFoundException;
import com.amazonaws.services.codepipeline.model.ActionTypeNotFoundException;
import com.amazonaws.services.codepipeline.model.ApprovalAlreadyCompletedException;
import com.amazonaws.services.codepipeline.model.CreateCustomActionTypeRequest;
import com.amazonaws.services.codepipeline.model.CreateCustomActionTypeResult;
import com.amazonaws.services.codepipeline.model.CreatePipelineRequest;
import com.amazonaws.services.codepipeline.model.CreatePipelineResult;
import com.amazonaws.services.codepipeline.model.DeleteCustomActionTypeRequest;
import com.amazonaws.services.codepipeline.model.DeleteCustomActionTypeResult;
import com.amazonaws.services.codepipeline.model.DeletePipelineRequest;
import com.amazonaws.services.codepipeline.model.DeletePipelineResult;
import com.amazonaws.services.codepipeline.model.DisableStageTransitionRequest;
import com.amazonaws.services.codepipeline.model.DisableStageTransitionResult;
import com.amazonaws.services.codepipeline.model.EnableStageTransitionRequest;
import com.amazonaws.services.codepipeline.model.EnableStageTransitionResult;
import com.amazonaws.services.codepipeline.model.GetJobDetailsRequest;
import com.amazonaws.services.codepipeline.model.GetJobDetailsResult;
import com.amazonaws.services.codepipeline.model.GetPipelineExecutionRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineExecutionResult;
import com.amazonaws.services.codepipeline.model.GetPipelineRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineResult;
import com.amazonaws.services.codepipeline.model.GetPipelineStateRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineStateResult;
import com.amazonaws.services.codepipeline.model.GetThirdPartyJobDetailsRequest;
import com.amazonaws.services.codepipeline.model.GetThirdPartyJobDetailsResult;
import com.amazonaws.services.codepipeline.model.InvalidActionDeclarationException;
import com.amazonaws.services.codepipeline.model.InvalidApprovalTokenException;
import com.amazonaws.services.codepipeline.model.InvalidBlockerDeclarationException;
import com.amazonaws.services.codepipeline.model.InvalidClientTokenException;
import com.amazonaws.services.codepipeline.model.InvalidJobException;
import com.amazonaws.services.codepipeline.model.InvalidJobStateException;
import com.amazonaws.services.codepipeline.model.InvalidNextTokenException;
import com.amazonaws.services.codepipeline.model.InvalidNonceException;
import com.amazonaws.services.codepipeline.model.InvalidStageDeclarationException;
import com.amazonaws.services.codepipeline.model.InvalidStructureException;
import com.amazonaws.services.codepipeline.model.JobNotFoundException;
import com.amazonaws.services.codepipeline.model.LimitExceededException;
import com.amazonaws.services.codepipeline.model.ListActionTypesRequest;
import com.amazonaws.services.codepipeline.model.ListActionTypesResult;
import com.amazonaws.services.codepipeline.model.ListPipelineExecutionsRequest;
import com.amazonaws.services.codepipeline.model.ListPipelineExecutionsResult;
import com.amazonaws.services.codepipeline.model.ListPipelinesRequest;
import com.amazonaws.services.codepipeline.model.ListPipelinesResult;
import com.amazonaws.services.codepipeline.model.NotLatestPipelineExecutionException;
import com.amazonaws.services.codepipeline.model.PipelineExecutionNotFoundException;
import com.amazonaws.services.codepipeline.model.PipelineNameInUseException;
import com.amazonaws.services.codepipeline.model.PipelineNotFoundException;
import com.amazonaws.services.codepipeline.model.PipelineVersionNotFoundException;
import com.amazonaws.services.codepipeline.model.PollForJobsRequest;
import com.amazonaws.services.codepipeline.model.PollForJobsResult;
import com.amazonaws.services.codepipeline.model.PollForThirdPartyJobsRequest;
import com.amazonaws.services.codepipeline.model.PollForThirdPartyJobsResult;
import com.amazonaws.services.codepipeline.model.PutActionRevisionRequest;
import com.amazonaws.services.codepipeline.model.PutActionRevisionResult;
import com.amazonaws.services.codepipeline.model.PutApprovalResultRequest;
import com.amazonaws.services.codepipeline.model.PutApprovalResultResult;
import com.amazonaws.services.codepipeline.model.PutJobFailureResultRequest;
import com.amazonaws.services.codepipeline.model.PutJobFailureResultResult;
import com.amazonaws.services.codepipeline.model.PutJobSuccessResultRequest;
import com.amazonaws.services.codepipeline.model.PutJobSuccessResultResult;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobFailureResultRequest;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobFailureResultResult;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobSuccessResultResult;
import com.amazonaws.services.codepipeline.model.RetryStageExecutionRequest;
import com.amazonaws.services.codepipeline.model.RetryStageExecutionResult;
import com.amazonaws.services.codepipeline.model.StageNotFoundException;
import com.amazonaws.services.codepipeline.model.StageNotRetryableException;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionRequest;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionResult;
import com.amazonaws.services.codepipeline.model.UpdatePipelineRequest;
import com.amazonaws.services.codepipeline.model.UpdatePipelineResult;
import com.amazonaws.services.codepipeline.model.ValidationException;
import com.amazonaws.services.codepipeline.model.transform.AcknowledgeJobRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.AcknowledgeJobResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.AcknowledgeThirdPartyJobRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.AcknowledgeThirdPartyJobResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.CreateCustomActionTypeRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.CreateCustomActionTypeResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.CreatePipelineRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.CreatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.DeleteCustomActionTypeRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.DeleteCustomActionTypeResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.DeletePipelineRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.DeletePipelineResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.DisableStageTransitionRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.DisableStageTransitionResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.EnableStageTransitionRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.EnableStageTransitionResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetJobDetailsRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetJobDetailsResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetPipelineExecutionRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetPipelineExecutionResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetPipelineRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetPipelineResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetPipelineStateRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetPipelineStateResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetThirdPartyJobDetailsRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.GetThirdPartyJobDetailsResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.ListActionTypesRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ListActionTypesResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.ListPipelineExecutionsRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ListPipelineExecutionsResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.ListPipelinesRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ListPipelinesResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.PollForJobsRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PollForJobsResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.PollForThirdPartyJobsRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PollForThirdPartyJobsResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutActionRevisionRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutActionRevisionResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutApprovalResultRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutApprovalResultResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutJobFailureResultRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutJobFailureResultResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutJobSuccessResultRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutJobSuccessResultResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutThirdPartyJobFailureResultRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutThirdPartyJobFailureResultResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutThirdPartyJobSuccessResultRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PutThirdPartyJobSuccessResultResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.RetryStageExecutionRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.RetryStageExecutionResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.StartPipelineExecutionRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.StartPipelineExecutionResultJsonUnmarshaller;
import com.amazonaws.services.codepipeline.model.transform.UpdatePipelineRequestProtocolMarshaller;
import com.amazonaws.services.codepipeline.model.transform.UpdatePipelineResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCodePipelineClient
extends AmazonWebServiceClient
implements AWSCodePipeline {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCodePipeline.class);
    private static final String DEFAULT_SIGNING_NAME = "codepipeline";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidClientTokenException").withModeledClass(InvalidClientTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidJobStateException").withModeledClass(InvalidJobStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineVersionNotFoundException").withModeledClass(PipelineVersionNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidApprovalTokenException").withModeledClass(InvalidApprovalTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidActionDeclarationException").withModeledClass(InvalidActionDeclarationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineExecutionNotFoundException").withModeledClass(PipelineExecutionNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ApprovalAlreadyCompletedException").withModeledClass(ApprovalAlreadyCompletedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineNameInUseException").withModeledClass(PipelineNameInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PipelineNotFoundException").withModeledClass(PipelineNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidJobException").withModeledClass(InvalidJobException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ActionTypeNotFoundException").withModeledClass(ActionTypeNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StageNotFoundException").withModeledClass(StageNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("StageNotRetryableException").withModeledClass(StageNotRetryableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidStructureException").withModeledClass(InvalidStructureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidBlockerDeclarationException").withModeledClass(InvalidBlockerDeclarationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ActionNotFoundException").withModeledClass(ActionNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidStageDeclarationException").withModeledClass(InvalidStageDeclarationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withModeledClass(ValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNonceException").withModeledClass(InvalidNonceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("JobNotFoundException").withModeledClass(JobNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotLatestPipelineExecutionException").withModeledClass(NotLatestPipelineExecutionException.class)).withBaseServiceExceptionClass(AWSCodePipelineException.class));

    @Deprecated
    public AWSCodePipelineClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AWSCodePipelineClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AWSCodePipelineClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AWSCodePipelineClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AWSCodePipelineClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AWSCodePipelineClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AWSCodePipelineClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AWSCodePipelineClientBuilder builder() {
        return AWSCodePipelineClientBuilder.standard();
    }

    AWSCodePipelineClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://codepipeline.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/codepipeline/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/codepipeline/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AcknowledgeJobResult acknowledgeJob(AcknowledgeJobRequest request) {
        request = (AcknowledgeJobRequest)this.beforeClientExecution(request);
        return this.executeAcknowledgeJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AcknowledgeJobResult executeAcknowledgeJob(AcknowledgeJobRequest acknowledgeJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(acknowledgeJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AcknowledgeJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AcknowledgeJobRequestProtocolMarshaller(this.protocolFactory).marshall((AcknowledgeJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)acknowledgeJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AcknowledgeJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AcknowledgeJobResult acknowledgeJobResult = (AcknowledgeJobResult)response.getAwsResponse();
            return acknowledgeJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AcknowledgeThirdPartyJobResult acknowledgeThirdPartyJob(AcknowledgeThirdPartyJobRequest request) {
        request = (AcknowledgeThirdPartyJobRequest)this.beforeClientExecution(request);
        return this.executeAcknowledgeThirdPartyJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AcknowledgeThirdPartyJobResult executeAcknowledgeThirdPartyJob(AcknowledgeThirdPartyJobRequest acknowledgeThirdPartyJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(acknowledgeThirdPartyJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AcknowledgeThirdPartyJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AcknowledgeThirdPartyJobRequestProtocolMarshaller(this.protocolFactory).marshall((AcknowledgeThirdPartyJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)acknowledgeThirdPartyJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AcknowledgeThirdPartyJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AcknowledgeThirdPartyJobResult acknowledgeThirdPartyJobResult = (AcknowledgeThirdPartyJobResult)response.getAwsResponse();
            return acknowledgeThirdPartyJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateCustomActionTypeResult createCustomActionType(CreateCustomActionTypeRequest request) {
        request = (CreateCustomActionTypeRequest)this.beforeClientExecution(request);
        return this.executeCreateCustomActionType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateCustomActionTypeResult executeCreateCustomActionType(CreateCustomActionTypeRequest createCustomActionTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createCustomActionTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateCustomActionTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateCustomActionTypeRequestProtocolMarshaller(this.protocolFactory).marshall((CreateCustomActionTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)createCustomActionTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateCustomActionTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateCustomActionTypeResult createCustomActionTypeResult = (CreateCustomActionTypeResult)response.getAwsResponse();
            return createCustomActionTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePipelineResult createPipeline(CreatePipelineRequest request) {
        request = (CreatePipelineRequest)this.beforeClientExecution(request);
        return this.executeCreatePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePipelineResult executeCreatePipeline(CreatePipelineRequest createPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePipelineRequestProtocolMarshaller(this.protocolFactory).marshall((CreatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePipelineResult createPipelineResult = (CreatePipelineResult)response.getAwsResponse();
            return createPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteCustomActionTypeResult deleteCustomActionType(DeleteCustomActionTypeRequest request) {
        request = (DeleteCustomActionTypeRequest)this.beforeClientExecution(request);
        return this.executeDeleteCustomActionType(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteCustomActionTypeResult executeDeleteCustomActionType(DeleteCustomActionTypeRequest deleteCustomActionTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteCustomActionTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteCustomActionTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteCustomActionTypeRequestProtocolMarshaller(this.protocolFactory).marshall((DeleteCustomActionTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteCustomActionTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteCustomActionTypeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteCustomActionTypeResult deleteCustomActionTypeResult = (DeleteCustomActionTypeResult)response.getAwsResponse();
            return deleteCustomActionTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePipelineResult deletePipeline(DeletePipelineRequest request) {
        request = (DeletePipelineRequest)this.beforeClientExecution(request);
        return this.executeDeletePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePipelineResult executeDeletePipeline(DeletePipelineRequest deletePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePipelineRequestProtocolMarshaller(this.protocolFactory).marshall((DeletePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePipelineResult deletePipelineResult = (DeletePipelineResult)response.getAwsResponse();
            return deletePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisableStageTransitionResult disableStageTransition(DisableStageTransitionRequest request) {
        request = (DisableStageTransitionRequest)this.beforeClientExecution(request);
        return this.executeDisableStageTransition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisableStageTransitionResult executeDisableStageTransition(DisableStageTransitionRequest disableStageTransitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableStageTransitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableStageTransitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableStageTransitionRequestProtocolMarshaller(this.protocolFactory).marshall((DisableStageTransitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableStageTransitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableStageTransitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableStageTransitionResult disableStageTransitionResult = (DisableStageTransitionResult)response.getAwsResponse();
            return disableStageTransitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EnableStageTransitionResult enableStageTransition(EnableStageTransitionRequest request) {
        request = (EnableStageTransitionRequest)this.beforeClientExecution(request);
        return this.executeEnableStageTransition(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EnableStageTransitionResult executeEnableStageTransition(EnableStageTransitionRequest enableStageTransitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableStageTransitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableStageTransitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableStageTransitionRequestProtocolMarshaller(this.protocolFactory).marshall((EnableStageTransitionRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableStageTransitionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableStageTransitionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableStageTransitionResult enableStageTransitionResult = (EnableStageTransitionResult)response.getAwsResponse();
            return enableStageTransitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetJobDetailsResult getJobDetails(GetJobDetailsRequest request) {
        request = (GetJobDetailsRequest)this.beforeClientExecution(request);
        return this.executeGetJobDetails(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetJobDetailsResult executeGetJobDetails(GetJobDetailsRequest getJobDetailsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getJobDetailsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobDetailsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobDetailsRequestProtocolMarshaller(this.protocolFactory).marshall((GetJobDetailsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getJobDetailsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetJobDetailsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetJobDetailsResult getJobDetailsResult = (GetJobDetailsResult)response.getAwsResponse();
            return getJobDetailsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPipelineResult getPipeline(GetPipelineRequest request) {
        request = (GetPipelineRequest)this.beforeClientExecution(request);
        return this.executeGetPipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPipelineResult executeGetPipeline(GetPipelineRequest getPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPipelineRequestProtocolMarshaller(this.protocolFactory).marshall((GetPipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPipelineResult getPipelineResult = (GetPipelineResult)response.getAwsResponse();
            return getPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPipelineExecutionResult getPipelineExecution(GetPipelineExecutionRequest request) {
        request = (GetPipelineExecutionRequest)this.beforeClientExecution(request);
        return this.executeGetPipelineExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPipelineExecutionResult executeGetPipelineExecution(GetPipelineExecutionRequest getPipelineExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPipelineExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPipelineExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPipelineExecutionRequestProtocolMarshaller(this.protocolFactory).marshall((GetPipelineExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPipelineExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPipelineExecutionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPipelineExecutionResult getPipelineExecutionResult = (GetPipelineExecutionResult)response.getAwsResponse();
            return getPipelineExecutionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPipelineStateResult getPipelineState(GetPipelineStateRequest request) {
        request = (GetPipelineStateRequest)this.beforeClientExecution(request);
        return this.executeGetPipelineState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPipelineStateResult executeGetPipelineState(GetPipelineStateRequest getPipelineStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPipelineStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPipelineStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPipelineStateRequestProtocolMarshaller(this.protocolFactory).marshall((GetPipelineStateRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPipelineStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPipelineStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPipelineStateResult getPipelineStateResult = (GetPipelineStateResult)response.getAwsResponse();
            return getPipelineStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetThirdPartyJobDetailsResult getThirdPartyJobDetails(GetThirdPartyJobDetailsRequest request) {
        request = (GetThirdPartyJobDetailsRequest)this.beforeClientExecution(request);
        return this.executeGetThirdPartyJobDetails(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetThirdPartyJobDetailsResult executeGetThirdPartyJobDetails(GetThirdPartyJobDetailsRequest getThirdPartyJobDetailsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getThirdPartyJobDetailsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetThirdPartyJobDetailsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetThirdPartyJobDetailsRequestProtocolMarshaller(this.protocolFactory).marshall((GetThirdPartyJobDetailsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getThirdPartyJobDetailsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetThirdPartyJobDetailsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetThirdPartyJobDetailsResult getThirdPartyJobDetailsResult = (GetThirdPartyJobDetailsResult)response.getAwsResponse();
            return getThirdPartyJobDetailsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListActionTypesResult listActionTypes(ListActionTypesRequest request) {
        request = (ListActionTypesRequest)this.beforeClientExecution(request);
        return this.executeListActionTypes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListActionTypesResult executeListActionTypes(ListActionTypesRequest listActionTypesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listActionTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListActionTypesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListActionTypesRequestProtocolMarshaller(this.protocolFactory).marshall((ListActionTypesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listActionTypesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListActionTypesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListActionTypesResult listActionTypesResult = (ListActionTypesResult)response.getAwsResponse();
            return listActionTypesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPipelineExecutionsResult listPipelineExecutions(ListPipelineExecutionsRequest request) {
        request = (ListPipelineExecutionsRequest)this.beforeClientExecution(request);
        return this.executeListPipelineExecutions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPipelineExecutionsResult executeListPipelineExecutions(ListPipelineExecutionsRequest listPipelineExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPipelineExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPipelineExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPipelineExecutionsRequestProtocolMarshaller(this.protocolFactory).marshall((ListPipelineExecutionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPipelineExecutionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPipelineExecutionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPipelineExecutionsResult listPipelineExecutionsResult = (ListPipelineExecutionsResult)response.getAwsResponse();
            return listPipelineExecutionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPipelinesResult listPipelines(ListPipelinesRequest request) {
        request = (ListPipelinesRequest)this.beforeClientExecution(request);
        return this.executeListPipelines(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPipelinesResult executeListPipelines(ListPipelinesRequest listPipelinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPipelinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPipelinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPipelinesRequestProtocolMarshaller(this.protocolFactory).marshall((ListPipelinesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPipelinesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPipelinesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPipelinesResult listPipelinesResult = (ListPipelinesResult)response.getAwsResponse();
            return listPipelinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PollForJobsResult pollForJobs(PollForJobsRequest request) {
        request = (PollForJobsRequest)this.beforeClientExecution(request);
        return this.executePollForJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PollForJobsResult executePollForJobs(PollForJobsRequest pollForJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(pollForJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PollForJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PollForJobsRequestProtocolMarshaller(this.protocolFactory).marshall((PollForJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)pollForJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PollForJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PollForJobsResult pollForJobsResult = (PollForJobsResult)response.getAwsResponse();
            return pollForJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PollForThirdPartyJobsResult pollForThirdPartyJobs(PollForThirdPartyJobsRequest request) {
        request = (PollForThirdPartyJobsRequest)this.beforeClientExecution(request);
        return this.executePollForThirdPartyJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PollForThirdPartyJobsResult executePollForThirdPartyJobs(PollForThirdPartyJobsRequest pollForThirdPartyJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(pollForThirdPartyJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PollForThirdPartyJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PollForThirdPartyJobsRequestProtocolMarshaller(this.protocolFactory).marshall((PollForThirdPartyJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)pollForThirdPartyJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PollForThirdPartyJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PollForThirdPartyJobsResult pollForThirdPartyJobsResult = (PollForThirdPartyJobsResult)response.getAwsResponse();
            return pollForThirdPartyJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutActionRevisionResult putActionRevision(PutActionRevisionRequest request) {
        request = (PutActionRevisionRequest)this.beforeClientExecution(request);
        return this.executePutActionRevision(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutActionRevisionResult executePutActionRevision(PutActionRevisionRequest putActionRevisionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putActionRevisionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutActionRevisionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutActionRevisionRequestProtocolMarshaller(this.protocolFactory).marshall((PutActionRevisionRequest)super.beforeMarshalling((AmazonWebServiceRequest)putActionRevisionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutActionRevisionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutActionRevisionResult putActionRevisionResult = (PutActionRevisionResult)response.getAwsResponse();
            return putActionRevisionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutApprovalResultResult putApprovalResult(PutApprovalResultRequest request) {
        request = (PutApprovalResultRequest)this.beforeClientExecution(request);
        return this.executePutApprovalResult(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutApprovalResultResult executePutApprovalResult(PutApprovalResultRequest putApprovalResultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putApprovalResultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutApprovalResultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutApprovalResultRequestProtocolMarshaller(this.protocolFactory).marshall((PutApprovalResultRequest)super.beforeMarshalling((AmazonWebServiceRequest)putApprovalResultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutApprovalResultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutApprovalResultResult putApprovalResultResult = (PutApprovalResultResult)response.getAwsResponse();
            return putApprovalResultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutJobFailureResultResult putJobFailureResult(PutJobFailureResultRequest request) {
        request = (PutJobFailureResultRequest)this.beforeClientExecution(request);
        return this.executePutJobFailureResult(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutJobFailureResultResult executePutJobFailureResult(PutJobFailureResultRequest putJobFailureResultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putJobFailureResultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutJobFailureResultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutJobFailureResultRequestProtocolMarshaller(this.protocolFactory).marshall((PutJobFailureResultRequest)super.beforeMarshalling((AmazonWebServiceRequest)putJobFailureResultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutJobFailureResultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutJobFailureResultResult putJobFailureResultResult = (PutJobFailureResultResult)response.getAwsResponse();
            return putJobFailureResultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutJobSuccessResultResult putJobSuccessResult(PutJobSuccessResultRequest request) {
        request = (PutJobSuccessResultRequest)this.beforeClientExecution(request);
        return this.executePutJobSuccessResult(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutJobSuccessResultResult executePutJobSuccessResult(PutJobSuccessResultRequest putJobSuccessResultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putJobSuccessResultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutJobSuccessResultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutJobSuccessResultRequestProtocolMarshaller(this.protocolFactory).marshall((PutJobSuccessResultRequest)super.beforeMarshalling((AmazonWebServiceRequest)putJobSuccessResultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutJobSuccessResultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutJobSuccessResultResult putJobSuccessResultResult = (PutJobSuccessResultResult)response.getAwsResponse();
            return putJobSuccessResultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutThirdPartyJobFailureResultResult putThirdPartyJobFailureResult(PutThirdPartyJobFailureResultRequest request) {
        request = (PutThirdPartyJobFailureResultRequest)this.beforeClientExecution(request);
        return this.executePutThirdPartyJobFailureResult(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutThirdPartyJobFailureResultResult executePutThirdPartyJobFailureResult(PutThirdPartyJobFailureResultRequest putThirdPartyJobFailureResultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putThirdPartyJobFailureResultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutThirdPartyJobFailureResultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutThirdPartyJobFailureResultRequestProtocolMarshaller(this.protocolFactory).marshall((PutThirdPartyJobFailureResultRequest)super.beforeMarshalling((AmazonWebServiceRequest)putThirdPartyJobFailureResultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutThirdPartyJobFailureResultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutThirdPartyJobFailureResultResult putThirdPartyJobFailureResultResult = (PutThirdPartyJobFailureResultResult)response.getAwsResponse();
            return putThirdPartyJobFailureResultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutThirdPartyJobSuccessResultResult putThirdPartyJobSuccessResult(PutThirdPartyJobSuccessResultRequest request) {
        request = (PutThirdPartyJobSuccessResultRequest)this.beforeClientExecution(request);
        return this.executePutThirdPartyJobSuccessResult(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutThirdPartyJobSuccessResultResult executePutThirdPartyJobSuccessResult(PutThirdPartyJobSuccessResultRequest putThirdPartyJobSuccessResultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putThirdPartyJobSuccessResultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutThirdPartyJobSuccessResultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutThirdPartyJobSuccessResultRequestProtocolMarshaller(this.protocolFactory).marshall((PutThirdPartyJobSuccessResultRequest)super.beforeMarshalling((AmazonWebServiceRequest)putThirdPartyJobSuccessResultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutThirdPartyJobSuccessResultResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutThirdPartyJobSuccessResultResult putThirdPartyJobSuccessResultResult = (PutThirdPartyJobSuccessResultResult)response.getAwsResponse();
            return putThirdPartyJobSuccessResultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RetryStageExecutionResult retryStageExecution(RetryStageExecutionRequest request) {
        request = (RetryStageExecutionRequest)this.beforeClientExecution(request);
        return this.executeRetryStageExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RetryStageExecutionResult executeRetryStageExecution(RetryStageExecutionRequest retryStageExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(retryStageExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RetryStageExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RetryStageExecutionRequestProtocolMarshaller(this.protocolFactory).marshall((RetryStageExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)retryStageExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RetryStageExecutionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RetryStageExecutionResult retryStageExecutionResult = (RetryStageExecutionResult)response.getAwsResponse();
            return retryStageExecutionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartPipelineExecutionResult startPipelineExecution(StartPipelineExecutionRequest request) {
        request = (StartPipelineExecutionRequest)this.beforeClientExecution(request);
        return this.executeStartPipelineExecution(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartPipelineExecutionResult executeStartPipelineExecution(StartPipelineExecutionRequest startPipelineExecutionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startPipelineExecutionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartPipelineExecutionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartPipelineExecutionRequestProtocolMarshaller(this.protocolFactory).marshall((StartPipelineExecutionRequest)super.beforeMarshalling((AmazonWebServiceRequest)startPipelineExecutionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartPipelineExecutionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartPipelineExecutionResult startPipelineExecutionResult = (StartPipelineExecutionResult)response.getAwsResponse();
            return startPipelineExecutionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePipelineResult updatePipeline(UpdatePipelineRequest request) {
        request = (UpdatePipelineRequest)this.beforeClientExecution(request);
        return this.executeUpdatePipeline(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePipelineResult executeUpdatePipeline(UpdatePipelineRequest updatePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePipelineRequestProtocolMarshaller(this.protocolFactory).marshall((UpdatePipelineRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePipelineRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePipelineResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePipelineResult updatePipelineResult = (UpdatePipelineResult)response.getAwsResponse();
            return updatePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

