/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codegurusecurity.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The identifier for a resource object that contains resources where a finding was detected.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ResourceId" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ResourceId implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The identifier for the code file uploaded to the resource where a finding was detected.
     * </p>
     */
    private String codeArtifactId;

    /**
     * <p>
     * The identifier for the code file uploaded to the resource where a finding was detected.
     * </p>
     * 
     * @param codeArtifactId
     *        The identifier for the code file uploaded to the resource where a finding was detected.
     */

    public void setCodeArtifactId(String codeArtifactId) {
        this.codeArtifactId = codeArtifactId;
    }

    /**
     * <p>
     * The identifier for the code file uploaded to the resource where a finding was detected.
     * </p>
     * 
     * @return The identifier for the code file uploaded to the resource where a finding was detected.
     */

    public String getCodeArtifactId() {
        return this.codeArtifactId;
    }

    /**
     * <p>
     * The identifier for the code file uploaded to the resource where a finding was detected.
     * </p>
     * 
     * @param codeArtifactId
     *        The identifier for the code file uploaded to the resource where a finding was detected.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceId withCodeArtifactId(String codeArtifactId) {
        setCodeArtifactId(codeArtifactId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCodeArtifactId() != null)
            sb.append("CodeArtifactId: ").append(getCodeArtifactId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ResourceId == false)
            return false;
        ResourceId other = (ResourceId) obj;
        if (other.getCodeArtifactId() == null ^ this.getCodeArtifactId() == null)
            return false;
        if (other.getCodeArtifactId() != null && other.getCodeArtifactId().equals(this.getCodeArtifactId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCodeArtifactId() == null) ? 0 : getCodeArtifactId().hashCode());
        return hashCode;
    }

    @Override
    public ResourceId clone() {
        try {
            return (ResourceId) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.codegurusecurity.model.transform.ResourceIdMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
