/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codecommit.model.BlobMetadata;

@SdkInternalApi
public class BlobMetadataMarshaller {
    private static final MarshallingInfo<String> BLOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blobId").build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("path").build();
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mode").build();
    private static final BlobMetadataMarshaller instance = new BlobMetadataMarshaller();

    public static BlobMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(BlobMetadata blobMetadata, ProtocolMarshaller protocolMarshaller) {
        if (blobMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)blobMetadata.getBlobId(), BLOBID_BINDING);
            protocolMarshaller.marshall((Object)blobMetadata.getPath(), PATH_BINDING);
            protocolMarshaller.marshall((Object)blobMetadata.getMode(), MODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

