/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codebuild.model.ComputeType;
import com.amazonaws.services.codebuild.model.EnvironmentType;
import com.amazonaws.services.codebuild.model.FleetOverflowBehavior;
import com.amazonaws.services.codebuild.model.ScalingConfigurationInput;
import com.amazonaws.services.codebuild.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateFleetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private Integer baseCapacity;
    private String environmentType;
    private String computeType;
    private ScalingConfigurationInput scalingConfiguration;
    private String overflowBehavior;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateFleetRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setBaseCapacity(Integer baseCapacity) {
        this.baseCapacity = baseCapacity;
    }

    public Integer getBaseCapacity() {
        return this.baseCapacity;
    }

    public CreateFleetRequest withBaseCapacity(Integer baseCapacity) {
        this.setBaseCapacity(baseCapacity);
        return this;
    }

    public void setEnvironmentType(String environmentType) {
        this.environmentType = environmentType;
    }

    public String getEnvironmentType() {
        return this.environmentType;
    }

    public CreateFleetRequest withEnvironmentType(String environmentType) {
        this.setEnvironmentType(environmentType);
        return this;
    }

    public CreateFleetRequest withEnvironmentType(EnvironmentType environmentType) {
        this.environmentType = environmentType.toString();
        return this;
    }

    public void setComputeType(String computeType) {
        this.computeType = computeType;
    }

    public String getComputeType() {
        return this.computeType;
    }

    public CreateFleetRequest withComputeType(String computeType) {
        this.setComputeType(computeType);
        return this;
    }

    public CreateFleetRequest withComputeType(ComputeType computeType) {
        this.computeType = computeType.toString();
        return this;
    }

    public void setScalingConfiguration(ScalingConfigurationInput scalingConfiguration) {
        this.scalingConfiguration = scalingConfiguration;
    }

    public ScalingConfigurationInput getScalingConfiguration() {
        return this.scalingConfiguration;
    }

    public CreateFleetRequest withScalingConfiguration(ScalingConfigurationInput scalingConfiguration) {
        this.setScalingConfiguration(scalingConfiguration);
        return this;
    }

    public void setOverflowBehavior(String overflowBehavior) {
        this.overflowBehavior = overflowBehavior;
    }

    public String getOverflowBehavior() {
        return this.overflowBehavior;
    }

    public CreateFleetRequest withOverflowBehavior(String overflowBehavior) {
        this.setOverflowBehavior(overflowBehavior);
        return this;
    }

    public CreateFleetRequest withOverflowBehavior(FleetOverflowBehavior overflowBehavior) {
        this.overflowBehavior = overflowBehavior.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateFleetRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateFleetRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getBaseCapacity() != null) {
            sb.append("BaseCapacity: ").append(this.getBaseCapacity()).append(",");
        }
        if (this.getEnvironmentType() != null) {
            sb.append("EnvironmentType: ").append(this.getEnvironmentType()).append(",");
        }
        if (this.getComputeType() != null) {
            sb.append("ComputeType: ").append(this.getComputeType()).append(",");
        }
        if (this.getScalingConfiguration() != null) {
            sb.append("ScalingConfiguration: ").append(this.getScalingConfiguration()).append(",");
        }
        if (this.getOverflowBehavior() != null) {
            sb.append("OverflowBehavior: ").append(this.getOverflowBehavior()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getBaseCapacity() == null ^ this.getBaseCapacity() == null) {
            return false;
        }
        if (other.getBaseCapacity() != null && !other.getBaseCapacity().equals(this.getBaseCapacity())) {
            return false;
        }
        if (other.getEnvironmentType() == null ^ this.getEnvironmentType() == null) {
            return false;
        }
        if (other.getEnvironmentType() != null && !other.getEnvironmentType().equals(this.getEnvironmentType())) {
            return false;
        }
        if (other.getComputeType() == null ^ this.getComputeType() == null) {
            return false;
        }
        if (other.getComputeType() != null && !other.getComputeType().equals(this.getComputeType())) {
            return false;
        }
        if (other.getScalingConfiguration() == null ^ this.getScalingConfiguration() == null) {
            return false;
        }
        if (other.getScalingConfiguration() != null && !other.getScalingConfiguration().equals(this.getScalingConfiguration())) {
            return false;
        }
        if (other.getOverflowBehavior() == null ^ this.getOverflowBehavior() == null) {
            return false;
        }
        if (other.getOverflowBehavior() != null && !other.getOverflowBehavior().equals(this.getOverflowBehavior())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getBaseCapacity() == null ? 0 : this.getBaseCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentType() == null ? 0 : this.getEnvironmentType().hashCode());
        hashCode = 31 * hashCode + (this.getComputeType() == null ? 0 : this.getComputeType().hashCode());
        hashCode = 31 * hashCode + (this.getScalingConfiguration() == null ? 0 : this.getScalingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getOverflowBehavior() == null ? 0 : this.getOverflowBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateFleetRequest clone() {
        return (CreateFleetRequest)super.clone();
    }
}

