/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.WebhookFilterType;
import com.amazonaws.services.codebuild.model.transform.WebhookFilterMarshaller;
import java.io.Serializable;

public class WebhookFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String pattern;
    private Boolean excludeMatchedPattern;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public WebhookFilter withType(String type) {
        this.setType(type);
        return this;
    }

    public WebhookFilter withType(WebhookFilterType type) {
        this.type = type.toString();
        return this;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public WebhookFilter withPattern(String pattern) {
        this.setPattern(pattern);
        return this;
    }

    public void setExcludeMatchedPattern(Boolean excludeMatchedPattern) {
        this.excludeMatchedPattern = excludeMatchedPattern;
    }

    public Boolean getExcludeMatchedPattern() {
        return this.excludeMatchedPattern;
    }

    public WebhookFilter withExcludeMatchedPattern(Boolean excludeMatchedPattern) {
        this.setExcludeMatchedPattern(excludeMatchedPattern);
        return this;
    }

    public Boolean isExcludeMatchedPattern() {
        return this.excludeMatchedPattern;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getPattern() != null) {
            sb.append("Pattern: ").append(this.getPattern()).append(",");
        }
        if (this.getExcludeMatchedPattern() != null) {
            sb.append("ExcludeMatchedPattern: ").append(this.getExcludeMatchedPattern());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebhookFilter)) {
            return false;
        }
        WebhookFilter other = (WebhookFilter)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getPattern() == null ^ this.getPattern() == null) {
            return false;
        }
        if (other.getPattern() != null && !other.getPattern().equals(this.getPattern())) {
            return false;
        }
        if (other.getExcludeMatchedPattern() == null ^ this.getExcludeMatchedPattern() == null) {
            return false;
        }
        return other.getExcludeMatchedPattern() == null || other.getExcludeMatchedPattern().equals(this.getExcludeMatchedPattern());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getPattern() == null ? 0 : this.getPattern().hashCode());
        hashCode = 31 * hashCode + (this.getExcludeMatchedPattern() == null ? 0 : this.getExcludeMatchedPattern().hashCode());
        return hashCode;
    }

    public WebhookFilter clone() {
        try {
            return (WebhookFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebhookFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

