/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.BucketOwnerAccess;
import com.amazonaws.services.codebuild.model.LogsConfigStatusType;
import com.amazonaws.services.codebuild.model.transform.S3LogsConfigMarshaller;
import java.io.Serializable;

public class S3LogsConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String status;
    private String location;
    private Boolean encryptionDisabled;
    private String bucketOwnerAccess;

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public S3LogsConfig withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public S3LogsConfig withStatus(LogsConfigStatusType status) {
        this.status = status.toString();
        return this;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public S3LogsConfig withLocation(String location) {
        this.setLocation(location);
        return this;
    }

    public void setEncryptionDisabled(Boolean encryptionDisabled) {
        this.encryptionDisabled = encryptionDisabled;
    }

    public Boolean getEncryptionDisabled() {
        return this.encryptionDisabled;
    }

    public S3LogsConfig withEncryptionDisabled(Boolean encryptionDisabled) {
        this.setEncryptionDisabled(encryptionDisabled);
        return this;
    }

    public Boolean isEncryptionDisabled() {
        return this.encryptionDisabled;
    }

    public void setBucketOwnerAccess(String bucketOwnerAccess) {
        this.bucketOwnerAccess = bucketOwnerAccess;
    }

    public String getBucketOwnerAccess() {
        return this.bucketOwnerAccess;
    }

    public S3LogsConfig withBucketOwnerAccess(String bucketOwnerAccess) {
        this.setBucketOwnerAccess(bucketOwnerAccess);
        return this;
    }

    public S3LogsConfig withBucketOwnerAccess(BucketOwnerAccess bucketOwnerAccess) {
        this.bucketOwnerAccess = bucketOwnerAccess.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getEncryptionDisabled() != null) {
            sb.append("EncryptionDisabled: ").append(this.getEncryptionDisabled()).append(",");
        }
        if (this.getBucketOwnerAccess() != null) {
            sb.append("BucketOwnerAccess: ").append(this.getBucketOwnerAccess());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3LogsConfig)) {
            return false;
        }
        S3LogsConfig other = (S3LogsConfig)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getEncryptionDisabled() == null ^ this.getEncryptionDisabled() == null) {
            return false;
        }
        if (other.getEncryptionDisabled() != null && !other.getEncryptionDisabled().equals(this.getEncryptionDisabled())) {
            return false;
        }
        if (other.getBucketOwnerAccess() == null ^ this.getBucketOwnerAccess() == null) {
            return false;
        }
        return other.getBucketOwnerAccess() == null || other.getBucketOwnerAccess().equals(this.getBucketOwnerAccess());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionDisabled() == null ? 0 : this.getEncryptionDisabled().hashCode());
        hashCode = 31 * hashCode + (this.getBucketOwnerAccess() == null ? 0 : this.getBucketOwnerAccess().hashCode());
        return hashCode;
    }

    public S3LogsConfig clone() {
        try {
            return (S3LogsConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3LogsConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

