/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.services.codebuild.model.ProjectArtifacts;
import com.amazonaws.services.codebuild.model.ProjectEnvironment;
import com.amazonaws.services.codebuild.model.ProjectSource;
import com.amazonaws.services.codebuild.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Project
implements Serializable,
Cloneable {
    private String name;
    private String arn;
    private String description;
    private ProjectSource source;
    private ProjectArtifacts artifacts;
    private ProjectEnvironment environment;
    private String serviceRole;
    private Integer timeoutInMinutes;
    private String encryptionKey;
    private List<Tag> tags;
    private Date created;
    private Date lastModified;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Project withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Project withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Project withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setSource(ProjectSource source) {
        this.source = source;
    }

    public ProjectSource getSource() {
        return this.source;
    }

    public Project withSource(ProjectSource source) {
        this.setSource(source);
        return this;
    }

    public void setArtifacts(ProjectArtifacts artifacts) {
        this.artifacts = artifacts;
    }

    public ProjectArtifacts getArtifacts() {
        return this.artifacts;
    }

    public Project withArtifacts(ProjectArtifacts artifacts) {
        this.setArtifacts(artifacts);
        return this;
    }

    public void setEnvironment(ProjectEnvironment environment) {
        this.environment = environment;
    }

    public ProjectEnvironment getEnvironment() {
        return this.environment;
    }

    public Project withEnvironment(ProjectEnvironment environment) {
        this.setEnvironment(environment);
        return this;
    }

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    public String getServiceRole() {
        return this.serviceRole;
    }

    public Project withServiceRole(String serviceRole) {
        this.setServiceRole(serviceRole);
        return this;
    }

    public void setTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public Integer getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public Project withTimeoutInMinutes(Integer timeoutInMinutes) {
        this.setTimeoutInMinutes(timeoutInMinutes);
        return this;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public Project withEncryptionKey(String encryptionKey) {
        this.setEncryptionKey(encryptionKey);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public Project withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Project withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getCreated() {
        return this.created;
    }

    public Project withCreated(Date created) {
        this.setCreated(created);
        return this;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public Project withLastModified(Date lastModified) {
        this.setLastModified(lastModified);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getArtifacts() != null) {
            sb.append("Artifacts: ").append(this.getArtifacts()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getServiceRole() != null) {
            sb.append("ServiceRole: ").append(this.getServiceRole()).append(",");
        }
        if (this.getTimeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.getTimeoutInMinutes()).append(",");
        }
        if (this.getEncryptionKey() != null) {
            sb.append("EncryptionKey: ").append(this.getEncryptionKey()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCreated() != null) {
            sb.append("Created: ").append(this.getCreated()).append(",");
        }
        if (this.getLastModified() != null) {
            sb.append("LastModified: ").append(this.getLastModified());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getArtifacts() == null ^ this.getArtifacts() == null) {
            return false;
        }
        if (other.getArtifacts() != null && !other.getArtifacts().equals(this.getArtifacts())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getServiceRole() == null ^ this.getServiceRole() == null) {
            return false;
        }
        if (other.getServiceRole() != null && !other.getServiceRole().equals(this.getServiceRole())) {
            return false;
        }
        if (other.getTimeoutInMinutes() == null ^ this.getTimeoutInMinutes() == null) {
            return false;
        }
        if (other.getTimeoutInMinutes() != null && !other.getTimeoutInMinutes().equals(this.getTimeoutInMinutes())) {
            return false;
        }
        if (other.getEncryptionKey() == null ^ this.getEncryptionKey() == null) {
            return false;
        }
        if (other.getEncryptionKey() != null && !other.getEncryptionKey().equals(this.getEncryptionKey())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCreated() == null ^ this.getCreated() == null) {
            return false;
        }
        if (other.getCreated() != null && !other.getCreated().equals(this.getCreated())) {
            return false;
        }
        if (other.getLastModified() == null ^ this.getLastModified() == null) {
            return false;
        }
        return other.getLastModified() == null || other.getLastModified().equals(this.getLastModified());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getArtifacts() == null ? 0 : this.getArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRole() == null ? 0 : this.getServiceRole().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInMinutes() == null ? 0 : this.getTimeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionKey() == null ? 0 : this.getEncryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCreated() == null ? 0 : this.getCreated().hashCode());
        hashCode = 31 * hashCode + (this.getLastModified() == null ? 0 : this.getLastModified().hashCode());
        return hashCode;
    }

    public Project clone() {
        try {
            return (Project)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

