/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codebuild.AWSCodeBuildAsync;
import com.amazonaws.services.codebuild.AWSCodeBuildClient;
import com.amazonaws.services.codebuild.model.BatchGetBuildsRequest;
import com.amazonaws.services.codebuild.model.BatchGetBuildsResult;
import com.amazonaws.services.codebuild.model.BatchGetProjectsRequest;
import com.amazonaws.services.codebuild.model.BatchGetProjectsResult;
import com.amazonaws.services.codebuild.model.CreateProjectRequest;
import com.amazonaws.services.codebuild.model.CreateProjectResult;
import com.amazonaws.services.codebuild.model.DeleteProjectRequest;
import com.amazonaws.services.codebuild.model.DeleteProjectResult;
import com.amazonaws.services.codebuild.model.ListBuildsForProjectRequest;
import com.amazonaws.services.codebuild.model.ListBuildsForProjectResult;
import com.amazonaws.services.codebuild.model.ListBuildsRequest;
import com.amazonaws.services.codebuild.model.ListBuildsResult;
import com.amazonaws.services.codebuild.model.ListCuratedEnvironmentImagesRequest;
import com.amazonaws.services.codebuild.model.ListCuratedEnvironmentImagesResult;
import com.amazonaws.services.codebuild.model.ListProjectsRequest;
import com.amazonaws.services.codebuild.model.ListProjectsResult;
import com.amazonaws.services.codebuild.model.StartBuildRequest;
import com.amazonaws.services.codebuild.model.StartBuildResult;
import com.amazonaws.services.codebuild.model.StopBuildRequest;
import com.amazonaws.services.codebuild.model.StopBuildResult;
import com.amazonaws.services.codebuild.model.UpdateProjectRequest;
import com.amazonaws.services.codebuild.model.UpdateProjectResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCodeBuildAsyncClient
extends AWSCodeBuildClient
implements AWSCodeBuildAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSCodeBuildAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSCodeBuildAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSCodeBuildAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetBuildsResult> batchGetBuildsAsync(BatchGetBuildsRequest request) {
        return this.batchGetBuildsAsync(request, null);
    }

    @Override
    public Future<BatchGetBuildsResult> batchGetBuildsAsync(final BatchGetBuildsRequest request, final AsyncHandler<BatchGetBuildsRequest, BatchGetBuildsResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchGetBuildsResult>(){

            @Override
            public BatchGetBuildsResult call() throws Exception {
                BatchGetBuildsResult result;
                try {
                    result = AWSCodeBuildAsyncClient.this.batchGetBuilds(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetProjectsResult> batchGetProjectsAsync(BatchGetProjectsRequest request) {
        return this.batchGetProjectsAsync(request, null);
    }

    @Override
    public Future<BatchGetProjectsResult> batchGetProjectsAsync(final BatchGetProjectsRequest request, final AsyncHandler<BatchGetProjectsRequest, BatchGetProjectsResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchGetProjectsResult>(){

            @Override
            public BatchGetProjectsResult call() throws Exception {
                BatchGetProjectsResult result;
                try {
                    result = AWSCodeBuildAsyncClient.this.batchGetProjects(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request) {
        return this.createProjectAsync(request, null);
    }

    @Override
    public Future<CreateProjectResult> createProjectAsync(final CreateProjectRequest request, final AsyncHandler<CreateProjectRequest, CreateProjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateProjectResult>(){

            @Override
            public CreateProjectResult call() throws Exception {
                CreateProjectResult result;
                try {
                    result = AWSCodeBuildAsyncClient.this.createProject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request) {
        return this.deleteProjectAsync(request, null);
    }

    @Override
    public Future<DeleteProjectResult> deleteProjectAsync(final DeleteProjectRequest request, final AsyncHandler<DeleteProjectRequest, DeleteProjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteProjectResult>(){

            @Override
            public DeleteProjectResult call() throws Exception {
                DeleteProjectResult result;
                try {
                    result = AWSCodeBuildAsyncClient.this.deleteProject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBuildsResult> listBuildsAsync(ListBuildsRequest request) {
        return this.listBuildsAsync(request, null);
    }

    @Override
    public Future<ListBuildsResult> listBuildsAsync(final ListBuildsRequest request, final AsyncHandler<ListBuildsRequest, ListBuildsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListBuildsResult>(){

            @Override
            public ListBuildsResult call() throws Exception {
                ListBuildsResult result;
                try {
                    result = AWSCodeBuildAsyncClient.this.listBuilds(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBuildsForProjectResult> listBuildsForProjectAsync(ListBuildsForProjectRequest request) {
        return this.listBuildsForProjectAsync(request, null);
    }

    @Override
    public Future<ListBuildsForProjectResult> listBuildsForProjectAsync(final ListBuildsForProjectRequest request, final AsyncHandler<ListBuildsForProjectRequest, ListBuildsForProjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListBuildsForProjectResult>(){

            @Override
            public ListBuildsForProjectResult call() throws Exception {
                ListBuildsForProjectResult result;
                try {
                    result = AWSCodeBuildAsyncClient.this.listBuildsForProject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCuratedEnvironmentImagesResult> listCuratedEnvironmentImagesAsync(ListCuratedEnvironmentImagesRequest request) {
        return this.listCuratedEnvironmentImagesAsync(request, null);
    }

    @Override
    public Future<ListCuratedEnvironmentImagesResult> listCuratedEnvironmentImagesAsync(final ListCuratedEnvironmentImagesRequest request, final AsyncHandler<ListCuratedEnvironmentImagesRequest, ListCuratedEnvironmentImagesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListCuratedEnvironmentImagesResult>(){

            @Override
            public ListCuratedEnvironmentImagesResult call() throws Exception {
                ListCuratedEnvironmentImagesResult result;
                try {
                    result = AWSCodeBuildAsyncClient.this.listCuratedEnvironmentImages(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request) {
        return this.listProjectsAsync(request, null);
    }

    @Override
    public Future<ListProjectsResult> listProjectsAsync(final ListProjectsRequest request, final AsyncHandler<ListProjectsRequest, ListProjectsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListProjectsResult>(){

            @Override
            public ListProjectsResult call() throws Exception {
                ListProjectsResult result;
                try {
                    result = AWSCodeBuildAsyncClient.this.listProjects(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartBuildResult> startBuildAsync(StartBuildRequest request) {
        return this.startBuildAsync(request, null);
    }

    @Override
    public Future<StartBuildResult> startBuildAsync(final StartBuildRequest request, final AsyncHandler<StartBuildRequest, StartBuildResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartBuildResult>(){

            @Override
            public StartBuildResult call() throws Exception {
                StartBuildResult result;
                try {
                    result = AWSCodeBuildAsyncClient.this.startBuild(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopBuildResult> stopBuildAsync(StopBuildRequest request) {
        return this.stopBuildAsync(request, null);
    }

    @Override
    public Future<StopBuildResult> stopBuildAsync(final StopBuildRequest request, final AsyncHandler<StopBuildRequest, StopBuildResult> asyncHandler) {
        return this.executorService.submit(new Callable<StopBuildResult>(){

            @Override
            public StopBuildResult call() throws Exception {
                StopBuildResult result;
                try {
                    result = AWSCodeBuildAsyncClient.this.stopBuild(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request) {
        return this.updateProjectAsync(request, null);
    }

    @Override
    public Future<UpdateProjectResult> updateProjectAsync(final UpdateProjectRequest request, final AsyncHandler<UpdateProjectRequest, UpdateProjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateProjectResult>(){

            @Override
            public UpdateProjectResult call() throws Exception {
                UpdateProjectResult result;
                try {
                    result = AWSCodeBuildAsyncClient.this.updateProject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

