/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters.tasks;

import com.amazonaws.codegen.emitters.FreemarkerGeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTask;
import com.amazonaws.codegen.emitters.GeneratorTaskParams;
import com.amazonaws.codegen.emitters.tasks.BaseGeneratorTasks;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class AsyncClientGeneratorTasks
extends BaseGeneratorTasks {
    private final String baseDirectory;

    public AsyncClientGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.baseDirectory = dependencies.getPathProvider().getBasePackageDirectory();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting Async client classes");
        return Arrays.asList(this.createClientClassTask(), this.createClientAbstractClassTask(), this.createClientBuilderTask(), this.createClientInterfaceTask());
    }

    private GeneratorTask createClientClassTask() throws IOException {
        return new FreemarkerGeneratorTask(this.baseDirectory, this.model.getMetadata().getAsyncClient(), this.freemarker.getAsyncClientTemplate(), this.model);
    }

    private GeneratorTask createClientAbstractClassTask() throws IOException {
        return new FreemarkerGeneratorTask(this.baseDirectory, this.model.getMetadata().getAsyncAbstractClass(), this.freemarker.getAsyncAbstractClassTemplate(), this.model);
    }

    private GeneratorTask createClientBuilderTask() throws IOException {
        return new FreemarkerGeneratorTask(this.baseDirectory, this.model.getMetadata().getAsyncClientBuilderClassName(), this.freemarker.getAsyncClientBuilderTemplate(), this.model);
    }

    private GeneratorTask createClientInterfaceTask() throws IOException {
        return new FreemarkerGeneratorTask(this.baseDirectory, this.model.getMetadata().getAsyncInterface(), this.freemarker.getAsyncInterfaceTemplate(), this.model);
    }
}

