/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.customization.processors;

import com.amazonaws.codegen.customization.CodegenCustomizationProcessor;
import com.amazonaws.codegen.model.config.customization.SimpleMethodFormsWrapper;
import com.amazonaws.codegen.model.intermediate.ArgumentModel;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.MemberModel;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.service.ServiceModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class SimpleMethodsProcessor
implements CodegenCustomizationProcessor {
    private final Map<String, SimpleMethodFormsWrapper> simpleMethods;

    SimpleMethodsProcessor(Map<String, SimpleMethodFormsWrapper> simpleMethods) {
        this.simpleMethods = simpleMethods;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        if (this.simpleMethods == null) {
            return;
        }
        Map<String, OperationModel> operationModels = intermediateModel.getOperations();
        Map<String, ShapeModel> shapeModels = intermediateModel.getShapes();
        for (Map.Entry<String, SimpleMethodFormsWrapper> entry : this.simpleMethods.entrySet()) {
            String operationName = entry.getKey();
            SimpleMethodFormsWrapper methodFormsWrapper = entry.getValue();
            OperationModel opModel = operationModels.get(operationName);
            if (opModel == null) {
                throw new RuntimeException("Simple Method forms customization present for an unknown operation " + operationName);
            }
            String inputShapeName = opModel.getInput().getSimpleType();
            ShapeModel shape = shapeModels.get(inputShapeName);
            List<List<String>> methodForms = methodFormsWrapper.getMethodForms();
            for (List<String> argumentList : methodForms) {
                ArrayList<ArgumentModel> simplifiedForm = new ArrayList<ArgumentModel>();
                for (String argument : argumentList) {
                    ArgumentModel argModel = new ArgumentModel();
                    MemberModel memberModel = shape.findMemberModelByC2jName(argument);
                    argModel.setDocumentation(memberModel.getDocumentation());
                    argModel.setName(memberModel.getVariable().getVariableName());
                    argModel.setType(memberModel.getVariable().getVariableType());
                    simplifiedForm.add(argModel);
                }
                opModel.addSimpleMethodForm(simplifiedForm);
            }
        }
    }
}

