/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.IntermediateModelBuilder;
import com.amazonaws.codegen.internal.DocumentationUtils;
import com.amazonaws.codegen.internal.TypeUtils;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.EnumModel;
import com.amazonaws.codegen.model.intermediate.ListModel;
import com.amazonaws.codegen.model.intermediate.MapModel;
import com.amazonaws.codegen.model.intermediate.MemberModel;
import com.amazonaws.codegen.model.intermediate.ParameterHttpMapping;
import com.amazonaws.codegen.model.intermediate.Protocol;
import com.amazonaws.codegen.model.intermediate.ReturnTypeModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.VariableModel;
import com.amazonaws.codegen.model.service.Location;
import com.amazonaws.codegen.model.service.Member;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Shape;
import com.amazonaws.codegen.naming.NamingStrategy;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.TimestampFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

abstract class AddShapes {
    private final IntermediateModelBuilder builder;
    private final NamingStrategy namingStrategy;

    AddShapes(IntermediateModelBuilder builder) {
        this.builder = builder;
        this.namingStrategy = builder.getNamingStrategy();
    }

    protected final TypeUtils getTypeUtils() {
        return this.builder.getTypeUtils();
    }

    protected final NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    protected final ServiceModel getServiceModel() {
        return this.builder.getService();
    }

    protected final CustomizationConfig getCustomizationConfig() {
        return this.builder.getCustomConfig();
    }

    protected final ShapeModel generateShapeModel(String javaClassName, String shapeName) {
        List<String> enumValues;
        ShapeModel shapeModel = new ShapeModel(shapeName);
        shapeModel.setShapeName(javaClassName);
        Shape shape = this.getServiceModel().getShapes().get(shapeName);
        shapeModel.setDocumentation(shape.getDocumentation());
        shapeModel.setVariable(new VariableModel(this.getNamingStrategy().getVariableName(javaClassName), javaClassName));
        shapeModel.setRequired(shape.getRequired());
        shapeModel.setDeprecated(shape.isDeprecated());
        shapeModel.setWrapper(shape.isWrapper());
        Map<String, Member> members = shape.getMembers();
        if (members != null) {
            boolean hasHeaderMember = false;
            boolean hasStatusCodeMember = false;
            boolean hasPayloadMember = false;
            boolean hasStreamingMember = false;
            boolean hasRequiresLength = false;
            for (Map.Entry<String, Member> memberEntry : members.entrySet()) {
                String c2jMemberName = memberEntry.getKey();
                Member c2jMemberDefinition = memberEntry.getValue();
                Shape parentShape = shape;
                MemberModel memberModel = this.generateMemberModel(c2jMemberName, c2jMemberDefinition, this.getProtocol(), parentShape, this.getServiceModel().getShapes());
                if (memberModel.getHttp().getLocation() == Location.HEADER) {
                    hasHeaderMember = true;
                } else if (memberModel.getHttp().getLocation() == Location.STATUS_CODE) {
                    hasStatusCodeMember = true;
                } else if (memberModel.getHttp().getIsPayload()) {
                    hasPayloadMember = true;
                    if (memberModel.getHttp().getIsStreaming()) {
                        hasStreamingMember = true;
                    }
                    if (memberModel.getHttp().isRequiresLength()) {
                        hasRequiresLength = true;
                    }
                }
                shapeModel.addMember(memberModel);
            }
            shapeModel.withHasHeaderMember(hasHeaderMember).withHasStatusCodeMember(hasStatusCodeMember).withHasPayloadMember(hasPayloadMember).withHasStreamingMember(hasStreamingMember).withHasRequiresLengthMember(hasRequiresLength);
        }
        if ((enumValues = shape.getEnumValues()) != null && !enumValues.isEmpty()) {
            for (String enumValue : enumValues) {
                shapeModel.addEnum(new EnumModel(this.getNamingStrategy().getEnumValueName(enumValue), enumValue));
            }
        }
        return shapeModel;
    }

    private MemberModel generateMemberModel(String c2jMemberName, Member c2jMemberDefinition, String protocol, Shape parentShape, Map<String, Shape> allC2jShapes) {
        String c2jShapeName = c2jMemberDefinition.getShape();
        Shape c2jShape = allC2jShapes.get(c2jMemberDefinition.getShape());
        String variableName = this.getNamingStrategy().getVariableName(c2jMemberName);
        String variableType = this.getTypeUtils().getJavaDataType(allC2jShapes, c2jShapeName);
        String variableDeclarationType = this.getTypeUtils().getJavaDataType(allC2jShapes, c2jShapeName, this.getCustomizationConfig());
        if (c2jMemberDefinition.isIdempotencyToken() && !variableType.equals(String.class.getSimpleName())) {
            throw new IllegalArgumentException(c2jMemberName + " is idempotent. It's shape should be string type but it is of " + variableType + " type.");
        }
        String timestampFormat = null;
        if (variableType.equals(Date.class.getName())) {
            timestampFormat = this.getDefaultTimeFormatIfNull(c2jMemberDefinition, allC2jShapes, protocol, parentShape);
        }
        MemberModel memberModel = new MemberModel();
        memberModel.withC2jName(c2jMemberName).withC2jShape(c2jShapeName).withName(Utils.capitialize(c2jMemberName)).withVariable(new VariableModel(variableName, variableType, variableDeclarationType, timestampFormat).withDocumentation(c2jMemberDefinition.getDocumentation())).withSetterModel(new VariableModel(variableName, variableType, variableDeclarationType).withDocumentation(DocumentationUtils.generateSetterDocumentation())).withGetterModel(new ReturnTypeModel(variableType).withDocumentation(DocumentationUtils.generateGetterDocumentation()));
        memberModel.setDocumentation(c2jMemberDefinition.getDocumentation());
        memberModel.setDeprecated(c2jMemberDefinition.isDeprecated());
        memberModel.setSensitive(this.isSensitiveShapeOrContainer(c2jMemberDefinition, allC2jShapes));
        memberModel.withGetterMethodName(this.namingStrategy.getGetterMethodName(c2jMemberName)).withSetterMethodName(this.namingStrategy.getSetterMethodName(c2jMemberName)).withFluentSetterMethodName(this.namingStrategy.getFluentSetterMethodName(c2jMemberName));
        memberModel.setIdempotencyToken(c2jMemberDefinition.isIdempotencyToken());
        if (c2jMemberDefinition.getXmlNamespace() != null) {
            memberModel.setXmlNameSpaceUri(c2jMemberDefinition.getXmlNamespace().getUri());
        }
        this.fillContainerTypeMemberMetadata(allC2jShapes, c2jMemberDefinition.getShape(), memberModel, protocol);
        ParameterHttpMapping httpMapping = this.generateParameterHttpMapping(parentShape, c2jMemberName, c2jMemberDefinition, protocol, allC2jShapes);
        String payload = parentShape.getPayload();
        boolean requiresLength = c2jShape.isRequiresLength() || c2jMemberDefinition.isRequiresLength();
        httpMapping.withPayload(payload != null && payload.equals(c2jMemberName)).withStreaming(c2jShape.isStreaming()).withRequiresLength(requiresLength);
        memberModel.setHttp(httpMapping);
        memberModel.setJsonValue(c2jMemberDefinition.isJsonvalue());
        return memberModel;
    }

    private boolean isSensitiveShapeOrContainer(Member member, Map<String, Shape> allC2jShapes) {
        if (member == null) {
            return false;
        }
        return member.isSensitive() || this.isSensitiveShapeOrContainer(allC2jShapes.get(member.getShape()), allC2jShapes);
    }

    private boolean isSensitiveShapeOrContainer(Shape c2jShape, Map<String, Shape> allC2jShapes) {
        if (c2jShape == null) {
            return false;
        }
        return c2jShape.isSensitive() || this.isSensitiveShapeOrContainer(c2jShape.getListMember(), allC2jShapes) || this.isSensitiveShapeOrContainer(c2jShape.getMapKeyType(), allC2jShapes) || this.isSensitiveShapeOrContainer(c2jShape.getMapValueType(), allC2jShapes);
    }

    protected String getDefaultTimeFormatIfNull(Member c2jMemberDefinition, Map<String, Shape> allC2jShapes, String protocolString, Shape parentShape) {
        String timestampFormat = c2jMemberDefinition.getTimestampFormat();
        if (!StringUtils.isNullOrEmpty((String)timestampFormat)) {
            this.failIfInCollection(c2jMemberDefinition, parentShape);
            return TimestampFormat.fromValue((String)timestampFormat).getFormat();
        }
        String shapeName = c2jMemberDefinition.getShape();
        Shape shape = allC2jShapes.get(shapeName);
        if (!StringUtils.isNullOrEmpty((String)shape.getTimestampFormat())) {
            this.failIfInCollection(c2jMemberDefinition, parentShape);
            return TimestampFormat.fromValue((String)shape.getTimestampFormat()).getFormat();
        }
        String location = c2jMemberDefinition.getLocation();
        if (Location.HEADER.toString().equals(location)) {
            return this.defaultHeaderTimestamp();
        }
        if (Location.QUERY_STRING.toString().equals(location)) {
            return TimestampFormat.ISO_8601.getFormat();
        }
        Protocol protocol = Protocol.fromValue(protocolString);
        switch (protocol) {
            case REST_XML: 
            case QUERY: 
            case EC2: 
            case API_GATEWAY: {
                return TimestampFormat.ISO_8601.getFormat();
            }
            case ION: 
            case REST_JSON: 
            case AWS_JSON: {
                return TimestampFormat.UNIX_TIMESTAMP.getFormat();
            }
            case CBOR: {
                return TimestampFormat.UNIX_TIMESTAMP_IN_MILLIS.getFormat();
            }
        }
        throw new RuntimeException("Cannot determine timestamp format for protocol " + (Object)((Object)protocol));
    }

    private void failIfInCollection(Member c2jMemberDefinition, Shape parentShape) {
        if (Utils.isMapShape(parentShape) || Utils.isListShape(parentShape)) {
            throw new IllegalArgumentException(String.format("Member (%s) has timestamp format provided. Timestamp format is not supported for Date in List/Map", c2jMemberDefinition.getShape()));
        }
    }

    protected String defaultHeaderTimestamp() {
        return TimestampFormat.RFC_822.getFormat();
    }

    private ParameterHttpMapping generateParameterHttpMapping(Shape parentShape, String memberName, Member member, String protocol, Map<String, Shape> allC2jShapes) {
        ParameterHttpMapping mapping = new ParameterHttpMapping();
        Shape memberShape = allC2jShapes.get(member.getShape());
        mapping.withLocation(Location.forValue(member.getLocation())).withPayload(member.isPayload()).withStreaming(member.isStreaming()).withFlattened(member.isFlattened() || memberShape.isFlattened()).withUnmarshallLocationName(this.deriveUnmarshallerLocationName(memberName, member)).withMarshallLocationName(this.deriveMarshallerLocationName(memberName, member, protocol)).withIsGreedy(this.isGreedy(parentShape, allC2jShapes, mapping));
        return mapping;
    }

    private boolean isGreedy(Shape parentShape, Map<String, Shape> allC2jShapes, ParameterHttpMapping mapping) {
        if (mapping.getLocation() == Location.URI) {
            String requestUri = this.findRequestUri(parentShape, allC2jShapes);
            if (requestUri.contains(String.format("{%s+}", mapping.getMarshallLocationName()))) {
                return true;
            }
        }
        return false;
    }

    private String findRequestUri(Shape parentShape, Map<String, Shape> allC2jShapes) {
        return this.builder.getService().getOperations().values().stream().filter(o -> o.getInput() != null).filter(o -> ((Shape)allC2jShapes.get(o.getInput().getShape())).equals(parentShape)).map(o -> o.getHttp().getRequestUri()).findFirst().orElseThrow(() -> new RuntimeException("Could not find request URI for input shape"));
    }

    private String deriveUnmarshallerLocationName(String memberName, Member member) {
        String locationName = member.getLocationName();
        if (locationName != null && !locationName.trim().isEmpty()) {
            return locationName;
        }
        return memberName;
    }

    private String deriveMarshallerLocationName(String memberName, Member member, String protocol) {
        String queryName = member.getQueryName();
        if (queryName != null && !queryName.trim().isEmpty()) {
            return queryName;
        }
        String locationName = member.getLocationName();
        if (locationName != null && !locationName.trim().isEmpty()) {
            if (protocol.equals(Protocol.EC2.getValue())) {
                return StringUtils.upperCase((String)locationName.substring(0, 1)) + locationName.substring(1);
            }
            return locationName;
        }
        return memberName;
    }

    private void fillContainerTypeMemberMetadata(Map<String, Shape> c2jShapes, String memberC2jShapeName, MemberModel memberModel, String protocol) {
        Shape memberC2jShape = c2jShapes.get(memberC2jShapeName);
        if (Utils.isListShape(memberC2jShape)) {
            Member listMemberDefinition = memberC2jShape.getListMember();
            String listMemberC2jShapeName = listMemberDefinition.getShape();
            Shape listMemberC2jShape = c2jShapes.get(listMemberC2jShapeName);
            MemberModel listMemberModel = this.generateMemberModel("member", listMemberDefinition, protocol, memberC2jShape, c2jShapes);
            String listImpl = this.getCustomizationConfig().isUseAutoConstructList() ? TypeUtils.getDataTypeMapping("listAutoConstructImpl") : TypeUtils.getDataTypeMapping("listDefaultImpl");
            memberModel.setListModel(new ListModel(this.getTypeUtils().getJavaDataType(c2jShapes, listMemberC2jShapeName), memberC2jShape.getListMember().getLocationName(), listImpl, TypeUtils.getDataTypeMapping("listInterface"), listMemberModel));
            if (listMemberC2jShape.getEnumValues() != null) {
                memberModel.setEnumType(this.getNamingStrategy().getJavaClassName(listMemberC2jShapeName));
            }
        } else if (Utils.isMapShape(memberC2jShape)) {
            MemberModel mapKeyModel = null;
            Member mapKeyMemberDefinition = memberC2jShape.getMapKeyType();
            String mapKeyShapeName = mapKeyMemberDefinition.getShape();
            Shape mapKeyShape = c2jShapes.get(mapKeyShapeName);
            Member mapValueMemberDefinition = memberC2jShape.getMapValueType();
            if (Utils.isEnumShape(mapKeyShape)) {
                mapKeyModel = this.generateMemberModel("key", mapKeyMemberDefinition, protocol, memberC2jShape, c2jShapes);
            } else if (!Utils.isScalar(mapKeyShape)) {
                throw new IllegalStateException("The key type of " + mapKeyShapeName + " must be a scalar!");
            }
            MemberModel mapValueModel = this.generateMemberModel("value", mapValueMemberDefinition, protocol, memberC2jShape, c2jShapes);
            String mapImpl = this.getCustomizationConfig().isUseAutoConstructMap() ? TypeUtils.getDataTypeMapping("mapAutoConstructImpl") : TypeUtils.getDataTypeMapping("mapDefaultImpl");
            String keyLocation = memberC2jShape.getMapKeyType().getLocationName() != null ? memberC2jShape.getMapKeyType().getLocationName() : "key";
            String valueLocation = memberC2jShape.getMapValueType().getLocationName() != null ? memberC2jShape.getMapValueType().getLocationName() : "value";
            memberModel.setMapModel(new MapModel(mapImpl, TypeUtils.getDataTypeMapping("mapInterface"), this.getTypeUtils().getJavaDataType(c2jShapes, memberC2jShape.getMapKeyType().getShape()), keyLocation, mapKeyModel, this.getTypeUtils().getJavaDataType(c2jShapes, memberC2jShape.getMapValueType().getShape()), valueLocation, mapValueModel));
        } else if (memberC2jShape.getEnumValues() != null) {
            memberModel.withEnumType(this.getNamingStrategy().getJavaClassName(memberC2jShapeName));
        }
    }

    protected String getProtocol() {
        return this.getServiceModel().getMetadata().getProtocol();
    }
}

