/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.model.intermediate;

import com.amazonaws.codegen.model.intermediate.DocumentationModel;
import com.amazonaws.codegen.model.service.Location;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class AuthorizerModel
extends DocumentationModel {
    private final String name;
    private final String interfaceName;
    private final Location authTokenLocation;
    private final String tokenName;

    public AuthorizerModel(String name, String interfaceName, Location authTokenLocation, String tokenName) {
        this.name = name;
        this.interfaceName = interfaceName;
        this.authTokenLocation = authTokenLocation;
        this.tokenName = tokenName;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasTokenPlacement() {
        return this.tokenName != null && this.authTokenLocation != null;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public Location getAuthTokenLocation() {
        return this.authTokenLocation;
    }

    @JsonIgnore
    public String getAddAuthTokenMethod() {
        switch (this.authTokenLocation) {
            case HEADER: {
                return "addHeader";
            }
            case QUERY_STRING: {
                return "addParameter";
            }
        }
        throw new IllegalArgumentException(String.format("Unhandled Location type for Auth Token Location '%s'", new Object[]{this.authTokenLocation}));
    }
}

