/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.customization.processors;

import com.amazonaws.codegen.customization.CodegenCustomizationProcessor;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.customization.ShapeModifier;
import com.amazonaws.codegen.model.config.customization.ShapeModifier_ModifyModel;
import com.amazonaws.codegen.model.intermediate.EnumModel;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.MemberModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.service.Member;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class ShapeModifiersProcessor
implements CodegenCustomizationProcessor {
    private final Map<String, ShapeModifier> shapeModifiers;
    private static final String ALL = "*";

    ShapeModifiersProcessor(Map<String, ShapeModifier> shapeModifiers) {
        this.shapeModifiers = shapeModifiers;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
        if (this.shapeModifiers == null) {
            return;
        }
        for (Map.Entry<String, ShapeModifier> entry : this.shapeModifiers.entrySet()) {
            String key = entry.getKey();
            ShapeModifier modifier = entry.getValue();
            if (ALL.equals(key)) {
                for (Shape shape : serviceModel.getShapes().values()) {
                    this.preprocess_ModifyShapeMembers(serviceModel, shape, modifier);
                }
                continue;
            }
            Shape shape = serviceModel.getShapes().get(key);
            if (shape == null) {
                throw new IllegalStateException("ShapeModifier customization found for " + key + ", but this shape doesn't exist in the model!");
            }
            this.preprocess_ModifyShapeMembers(serviceModel, shape, modifier);
        }
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        if (this.shapeModifiers == null) {
            return;
        }
        for (Map.Entry<String, ShapeModifier> entry : this.shapeModifiers.entrySet()) {
            ShapeModel shapeModel;
            String key = entry.getKey();
            ShapeModifier modifier = entry.getValue();
            if (ALL.equals(key)) continue;
            try {
                shapeModel = Utils.findShapeModelByC2jName(intermediateModel, key);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(String.format("Cannot find c2j shape [%s] in the intermediate model when processing customization config shapeModifiers.%s", key, key), e);
            }
            if (modifier.isExcludeShape()) {
                shapeModel.getCustomization().setSkipGeneratingModelClass(true);
                shapeModel.getCustomization().setSkipGeneratingMarshaller(true);
                shapeModel.getCustomization().setSkipGeneratingUnmarshaller(true);
                continue;
            }
            if (modifier.getModify() == null) continue;
            for (Map<String, ShapeModifier_ModifyModel> modifies : modifier.getModify()) {
                for (Map.Entry<String, ShapeModifier_ModifyModel> memberEntry : modifies.entrySet()) {
                    String enumToModify = memberEntry.getKey();
                    ShapeModifier_ModifyModel modifyModel = memberEntry.getValue();
                    this.postprocess_ModifyMemberProperty(shapeModel, enumToModify, modifyModel);
                }
            }
        }
    }

    private void postprocess_ModifyMemberProperty(ShapeModel shapeModel, String memberName, ShapeModifier_ModifyModel modifyModel) {
        MemberModel memberModel;
        if (modifyModel.getEmitEnumName() != null) {
            EnumModel enumModel = shapeModel.findEnumModelByValue(memberName);
            if (enumModel == null) {
                throw new IllegalStateException(String.format("Cannot find enum [%s] in the intermediate model when processing customization config shapeModifiers.%s", memberName, memberName));
            }
            enumModel.setName(modifyModel.getEmitEnumName());
        }
        if (modifyModel.getMarshallLocationName() != null) {
            memberModel = shapeModel.findMemberModelByC2jName(memberName);
            memberModel.getHttp().setMarshallLocationName(modifyModel.getMarshallLocationName());
        }
        if (modifyModel.getUnmarshallLocationName() != null) {
            memberModel = shapeModel.findMemberModelByC2jName(memberName);
            memberModel.getHttp().setUnmarshallLocationName(modifyModel.getUnmarshallLocationName());
        }
    }

    private void preprocess_ModifyShapeMembers(ServiceModel serviceModel, Shape shape, ShapeModifier modifier) {
        if (modifier.getModify() != null) {
            for (Map map : modifier.getModify()) {
                for (Map.Entry entry : map.entrySet()) {
                    String memberToModify = (String)entry.getKey();
                    ShapeModifier_ModifyModel modifyModel = (ShapeModifier_ModifyModel)entry.getValue();
                    this.doModifyShapeMembers(serviceModel, shape, memberToModify, modifyModel);
                }
            }
        }
        if (modifier.getExclude() != null) {
            for (String string : modifier.getExclude()) {
                if (shape.getRequired() != null && shape.getRequired().contains(string)) {
                    throw new IllegalStateException("ShapeModifier.exclude customization found for " + string + ", but this member is marked as required in the model!");
                }
                if (shape.getMembers() == null) continue;
                shape.getMembers().remove(string);
            }
        }
        if (modifier.getInject() != null) {
            for (Map map : modifier.getInject()) {
                if (shape.getMembers() == null) {
                    shape.setMembers(new HashMap<String, Member>());
                }
                shape.getMembers().putAll(map);
            }
        }
        if (modifier.getInjectEnumValues() != null) {
            if (shape.getEnumValues() == null) {
                throw new IllegalStateException("Attempted to add enum members to a non-enum shape!");
            }
            HashSet<String> extendValues = new HashSet<String>(shape.getEnumValues());
            extendValues.addAll(modifier.getInjectEnumValues());
            shape.setEnumValues(new ArrayList<String>(extendValues));
        }
    }

    private void doModifyShapeMembers(ServiceModel serviceModel, Shape shape, String memberToModify, ShapeModifier_ModifyModel modifyModel) {
        if (modifyModel.getEmitPropertyName() != null) {
            Member member = shape.getMembers().remove(memberToModify);
            if (member.getLocationName() == null) {
                member.setLocationName(memberToModify);
            }
            shape.getMembers().put(modifyModel.getEmitPropertyName(), member);
        }
        if (modifyModel.getEmitAsType() != null) {
            Shape newShapeForType = new Shape();
            newShapeForType.setType(modifyModel.getEmitAsType());
            String shapeName = "SDK_" + modifyModel.getEmitAsType();
            serviceModel.getShapes().put(shapeName, newShapeForType);
            shape.getMembers().get(memberToModify).setShape(shapeName);
        }
    }
}

